<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\ParserFactory;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleTypeCityAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithLocationDataInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithSocialMediaLinksAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ExternalIdSelector;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\CityAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\CongressLocationAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\DirectMarketerAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\GastronomyAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\GenericArticleAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\MonthConstants;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\PointOfInterestAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ExternalIdType;
use Newland\Toubiz\Api\ObjectAdapter\ExternalIdAdapter;
use Newland\Toubiz\Api\ObjectAdapter\HasAdditionalExternalIds;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\VimeoVideoAdapter;
use Newland\Toubiz\Api\ObjectAdapter\YoutubeVideoAdapter;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Utility\ArrayUtility;
use Psr\Log\LoggerAwareTrait;

class ArticleAdapter extends AbstractObjectAdapter implements
    ArticleAdapterInterface,
    ArticleWithLocationDataInterface,
    HasAdditionalExternalIds,
    ArticleWithSocialMediaLinksAdapterInterface,
    ArticleTypeCityAdapterInterface
{
    use LanguageAware, LoggerAwareTrait;

    /** @var int */
    protected $type;

    /** @var array|null */
    protected $cachedGeometry;

    const REGULAR_ATTRIBUTE_MAPPING = [
        GenericArticleAttributes::ADDITIONAL_SEARCH_STRING => 'seo.searchKeywords',
        CityAttributes::WEBCAM => 'contactInformation.webcam',
        CityAttributes::TAG => 'tags',
        DirectMarketerAttributes::PANORAMA => 'contactInformation.camera360',
        PointOfInterestAttributes::FREE_ENTRANCE => 'point.price.freeEntry',
        PointOfInterestAttributes::PRICE_INFORMATION => 'point.price.priceComment',
        TourAttributes::STATUS => 'tour.status',
        TourAttributes::CURRENT_INFO => 'currentInformation',
        TourAttributes::TECHNIQUE_RATING => 'tour.technique',
        TourAttributes::LANDSCAPE_RATING => 'tour.beauty',
        TourAttributes::EXPERIENCE_RATING => 'tour.popularity',
        TourAttributes::DIFFICULTY_RATING => 'tour.difficulty',
        TourAttributes::CONDITION_RATING => 'tour.fitness',
        TourAttributes::STARTING_POINT => 'tour.startPoint',
        TourAttributes::ENDING_POINT => 'tour.endPoint',
        TourAttributes::PUBLIC_TRANSIT => 'tour.publicTransit',
        TourAttributes::APPROACH => 'tour.startPointGettingThere',
        'gettingBackToStartPoint' => 'tour.endPointToStartPoint',
        TourAttributes::MAPS => 'tour.trustedMaps',
        TourAttributes::MINIMUM_ALTITUDE => 'tour.combinedTrackInformation.lowestPoint',
        TourAttributes::MAXIMUM_ALTITUDE => 'tour.combinedTrackInformation.highestPoint',
        TourAttributes::NECESARRY_EQUIPMENT => 'tour.gear',
        TourAttributes::ASCEND_ELEVATION => 'tour.combinedTrackInformation.elevationUp',
        TourAttributes::DESCENT_ELEVATION => 'tour.combinedTrackInformation.elevationDown',
        TourAttributes::ELEVATION_PROFILE => 'tour.combinedTrackInformation.heightProfile.url',
        TourAttributes::DIRECTIONS => 'tour.directions',
        TourAttributes::PARKING => 'tour.parking',
        TourAttributes::ADDITIONAL_INFORMATION => 'tour.moreInformation',
        'tipOfAuthor' => 'tour.authorTip',
        TourAttributes::SAFETY_NOTE => 'tour.safetyInformation',
        TourAttributes::LITERATURE_TIP_OF_AUTHOR => 'tour.literature',
        TourAttributes::FLIGHT_3D => 'contactInformation.aerial3d',
    ];

    const DYNAMIC_FIELD_MAPPING = [
        '69c22606-cacb-428c-b6e3-02ef233da101' => [
            [
                'mapValue' => 'b01ed159-38bd-495a-8870-fd5f3307654d',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_WIFI,
            ],
            [
                'mapValue' => '2ab78dba-408a-4a72-a12c-757118e55ff0',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_WIFI,
            ],
            [
                'mapValue' => 'a6f51850-bf66-4ca6-b3a8-cec9a90ccaa8',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_NICE_WC,
            ],
            [
                'mapValue' => 'b01ed159-38bd-495a-8870-fd5f3307654d',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_WIFI,
            ],
            [
                'mapValue' => '2ab78dba-408a-4a72-a12c-757118e55ff0',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_WIFI,
            ],
            [
                'mapValue' => 'a6f51850-bf66-4ca6-b3a8-cec9a90ccaa8',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_NICE_WC,
            ],
        ],

        // Congress location
        '486ad4bf-00ed-46ae-b635-20f4d44f14b2' => [
            [ 'intoField' => CongressLocationAttributes::NUMBER_OF_ROOMS ],
        ],
        '80aa1605-eb01-4b63-854a-b8f8e2d2353f' => [
            [ 'intoField' => CongressLocationAttributes::NUMBER_OF_ATTENDEES ],
        ],

        // Direct Marketers
        '7b9d3c1b-c78d-4be3-b7fc-1f74267cb05a' => [
            [
                'mapValue' => 'fa0923f4-4c17-485d-bbf0-1444fbded2db',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_FARM,
            ],
            [
                'mapValue' => '8d291454-e6a2-4476-95c6-68e34c5fefc9',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_HOME_DELIVERY,
            ],
            [
                'mapValue' => '10cf654d-5d31-46e5-ae95-fe099a0b7800',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_POSTAL_SHIPPING,
            ],
            [
                'mapValue' => '87f931f0-26cd-4382-8fe1-90a5f1b9483b',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_MARKET,
            ],
            [
                'mapValue' => '842b6b7d-cd99-490d-99b4-1cb38f6049b8',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_SHOP,
            ],
            [
                'mapValue' => 'd8454f6e-4839-402a-a07e-7467ca357c7c',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_SELF_SERVICE,
            ],
            [
                'mapValue' => '50eba4f7-fac2-4dfc-87b2-a03daf416b97',
                'intoField' => DirectMarketerAttributes::SHOPPING,
                'withValue' => DirectMarketerAttributes::SHOPPING_VENDING_MACHINE,
            ],
        ],
        '391dbcb6-d219-465f-a345-6868d1d385ae' => [
            [
                'mapValue' => '2675798e-f6a9-4de0-a35d-3e0942fb4b4b',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_HERBS,
            ],
            [
                'mapValue' => '6c87e282-db45-4ec3-b93a-c36b2242117d',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_TEA,
            ],
            [
                'mapValue' => '4b3b12af-9afd-483c-83bb-4cdc947905d1',
                'intoField' => DirectMarketerAttributes::OILS_SPREADS,
                'withValue' => DirectMarketerAttributes::OILS_SPREADS_SPREAD,
            ],
            [
                'mapValue' => 'f8d73918-fec3-4e62-baa1-933491f0bae0',
                'intoField' => DirectMarketerAttributes::OILS_SPREADS,
                'withValue' => DirectMarketerAttributes::OILS_SPREADS_HONEY,
            ],
            [
                'mapValue' => '9b3f4cac-3b56-42fc-990b-c46cef94a043',
                'intoField' => DirectMarketerAttributes::OILS_SPREADS,
                'withValue' => DirectMarketerAttributes::OILS_SPREADS_OIL_AND_VINEGAR,
            ],
            [
                'mapValue' => '9899212a-cb72-487d-bb2f-ee4afc398b4c',
                'intoField' => DirectMarketerAttributes::OILS_SPREADS,
                'withValue' => DirectMarketerAttributes::OILS_SPREADS_OIL_AND_VINEGAR,
            ],
            [
                'mapValue' => '0e55a3a9-d6c6-4d01-97e5-26e6dbbf37aa',
                'intoField' => DirectMarketerAttributes::OILS_SPREADS,
                'withValue' => DirectMarketerAttributes::OILS_SPREADS_JAM,
            ],
            [
                'mapValue' => 'f1d0228b-973a-40db-9bf2-601a754300f4',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_HERBS,
            ],
            [
                'mapValue' => '717e9b0f-f7f4-499d-b4c8-0996536de6e0',
                'intoField' => DirectMarketerAttributes::GRAINS,
                'withValue' => DirectMarketerAttributes::GRAINS_NUTS,
            ],
            [
                'mapValue' => '0cfeb964-44cc-4bc1-b442-95e90df8d00c',
                'intoField' => DirectMarketerAttributes::GRAINS,
                'withValue' => DirectMarketerAttributes::GRAINS_LEGUMES,
            ],
        ],
        '50abfaa5-ff10-4dff-b955-557af413ae5a' => [
            [
                'mapValue' => 'a0b9267a-363a-40df-a436-f0850c277339',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_POTATO,
            ],
            [
                'mapValue' => '1ddb58bf-6a6f-46cd-84b3-d9f2888494ad',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_SALAD,
            ],
            [
                'mapValue' => '7771b735-bcca-4c58-8a80-eb762ffeac0a',
                'intoField' => DirectMarketerAttributes::SEASONALS,
                'withValue' => DirectMarketerAttributes::SEASONALS_ASPARGUS,
            ],
            [
                'mapValue' => '1e293faa-31c4-470e-ac9d-2ed3e322ab6f',
                'intoField' => DirectMarketerAttributes::SEASONALS,
                'withValue' => DirectMarketerAttributes::SEASONALS_PUMPKIN,
            ],
            [
                'mapValue' => 'faddf3e9-48ef-4e9c-a826-cdac68d3e21c',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_PICKLED_VEGETABLES,
            ],
        ],
        '9815ee93-a083-4725-af07-8f86f97dad3f' => [
            [
                'mapValue' => 'f6188e99-9111-4e15-a61d-585e0e0ae710',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_JUICE,
            ],
            [
                'mapValue' => '52dbf145-bc42-440d-8929-b0cb1d29cf20',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_BEER,
            ],
            [
                'mapValue' => '82ff2083-9b1c-4c9f-a0f1-c1fe31b66490',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_SPARKLING_WINE,
            ],
            [
                'mapValue' => 'd10c1ec0-04d3-4d65-9e05-817ea6e1cb36',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_WINE,
            ],
            [
                'mapValue' => '148ce039-5eac-4508-8171-4ff5561e33ee',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_LIQUOR,
            ],
            [
                'mapValue' => 'ef30f481-997b-470f-bded-214f5809a918',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_FRUIT_WINE,
            ],
            [
                'mapValue' => '0a5a7105-905b-4156-80ca-15a892010f44',
                'intoField' => DirectMarketerAttributes::DRINKS,
                'withValue' => DirectMarketerAttributes::DRINKS_FRUIT_WINE,
            ],

        ],
        '75a0091e-90b7-4cc7-b19f-a675514a2f43' => [
            [
                'mapValue' => '14aa3ad-3600-416a-87d2-2bb5c01bcd43',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_LAMB,
            ],
            [
                'mapValue' => '63ada6e4-5623-4191-ab26-945e02b0cbde',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_BEEF,
            ],
            [
                'mapValue' => '56a2f70e-0b92-4d3c-9d24-cc2b36adf1bd',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_DEER,
            ],
            [
                'mapValue' => '1f16adcb-e6a4-4841-b06b-3f2cd556f4a0',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_GOAT,
            ],
            [
                'mapValue' => '01877c8a-82ed-4bab-a5c1-73ec36c54488',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_PORK,
            ],
            [
                'mapValue' => '46ff33cc-8808-449a-b4ce-5ebbb1a29cf8',
                'intoField' => DirectMarketerAttributes::MEATS,
                'withValue' => DirectMarketerAttributes::MEATS_RABBIT,
            ],
            [
                'mapValue' => '302b7b5e-37aa-4b99-8419-c9dba6236d29',
                'intoField' => DirectMarketerAttributes::FISH,
                'withValue' => DirectMarketerAttributes::FISH_FISH,
            ],

        ],
        '4ec4c622-a700-45a9-bf6b-150944bd25bd' => [
            [
                'mapValue' => 'ddb9cc33-153c-4709-b053-c2814078fd3b',
                'intoField' => DirectMarketerAttributes::MILK,
                'withValue' => DirectMarketerAttributes::MILK_MILK,
            ],
            [
                'mapValue' => '76d3043e-81b2-417a-880b-8265f7b9af50',
                'intoField' => DirectMarketerAttributes::MILK,
                'withValue' => DirectMarketerAttributes::MILK_QUARK,
            ],
            [
                'mapValue' => 'fa20067f-1ef7-4d4e-a607-1645aafbd2cb',
                'intoField' => DirectMarketerAttributes::MILK,
                'withValue' => DirectMarketerAttributes::MILK_YOGURT,
            ],
            [
                'mapValue' => '64f80960-3f4a-467b-bcbf-5e7a9fe8ab8e',
                'intoField' => DirectMarketerAttributes::MILK,
                'withValue' => DirectMarketerAttributes::MILK_GOAT,
            ],
            [
                'mapValue' => '9a293f6c-2d8a-4e36-9cc5-0aa590367930',
                'intoField' => DirectMarketerAttributes::MILK,
                'withValue' => DirectMarketerAttributes::MILK_ICE_CREAM,
            ],

        ],
        'c2fb38de-9a58-4e24-847b-df433c71488e' => [
            [
                'mapValue' => '191beb01-3a36-43bc-93f1-711918920e20',
                'intoField' => DirectMarketerAttributes::GRAINS,
                'withValue' => DirectMarketerAttributes::GRAINS_NOODLES,
            ],
            [
                'mapValue' => '2f132bee-9756-4769-a45e-78e38dcfa499',
                'intoField' => DirectMarketerAttributes::GRAINS,
                'withValue' => DirectMarketerAttributes::GRAINS_FLOUR,
            ],
        ],
        '81e8ab69-b4ca-46fd-b177-22fafa5ecdaa' => [
            [
                'mapValue' => '4d8cd919-c901-43ed-9ccd-99f29769ec59',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_DECORATIONS,
            ],
            [
                'mapValue' => '6ef4dedb-ebd5-43e9-b7b9-b17c7a6735b2',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_GLASS,
            ],
            [
                'mapValue' => '4feb74b9-24b5-4af5-b799-6b57e841abf0',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_WEAVING,
            ],
            [
                'mapValue' => 'd94478de-2a5f-4935-8e98-225c6e1ce903',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_FUR,
            ],
            [
                'mapValue' => '8507c691-6743-4f08-9016-206a74b2aa8d',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_WOOL,
            ],
            [
                'mapValue' => 'db877285-3cc0-42bf-8088-75542317b1b2',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_FLOWERS,
            ],
            [
                'mapValue' => 'cd6b9fd9-ffd5-4ecd-9a5e-6adf1f086b3c',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_CANDLES,
            ],
            [
                'mapValue' => '09f00ad5-a2b9-4008-b944-4c8e6cde851c',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_CERAMIC,
            ],
            [
                'mapValue' => 'dafd5225-c73e-4f57-a4e6-81a89d3d9208',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_ARTS,
            ],
            [
                'mapValue' => '4ad5526f-fc3b-49a4-8991-be49da9f3ad3',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_WROUGHT,
            ],
            [
                'mapValue' => '6c6e0b84-f471-4a94-b472-8f52ebad8732',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_ARTS,
            ],
            [
                'mapValue' => '940783bb-8cd4-495c-98b0-7e8bd5f0b1e9',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_COSMETICS,
            ],
            [
                'mapValue' => '227b572d-99e7-4b7c-a5e9-a46ce223bd88',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_TEXTILES,
            ],
            [
                'mapValue' => 'eacd3813-bf10-453f-be62-db1de866c367',
                'intoField' => DirectMarketerAttributes::CRAFTS,
                'withValue' => DirectMarketerAttributes::CRAFTS_WOOD_CARVING,
            ],
        ],
        '1695f392-9a1e-4f75-a954-ff6deebc839c' => [
            [ 'intoField' => DirectMarketerAttributes::AWARDS ],
        ],
        'f44d2249-3f4e-4354-b737-f649c98ecc43' => [
            [ 'intoField' => DirectMarketerAttributes::REGIONAL_AWARDS ],
        ],

        '7ccb42a0-3328-4e7e-9e92-5596eb40e8f3' => [
            [
                'mapValue' => '1fce0405-9efb-453a-8119-d976b446c44a',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_ECOLOGICAL_PRODUCTS,
            ],
            [
                'mapValue' => '8f61d1b1-5981-4633-b197-569fc2d71f76',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_PUBLICLY_OBSERVABLE_PRODUCTION,
            ],

        ],
        '02806c14-6254-45b1-9a3c-a779bc5c0dc9' => [
            [ 'intoField' => 'additionalAnimalProducts' ],
        ],
        '3a897743-2fa4-4a41-822e-439e1898e56c' => [
            [ 'intoField' => 'eggs' ],
        ],
        '2516742f-db51-4906-a0b4-abf17eaa5a73' => [
            [
                'mapValue' => '5ae4f2ef-5024-471d-832f-e2aea03859ea',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_APPLE,
            ],
            [
                'mapValue' => 'd9beacab-326a-47c2-834a-94868ec8a666',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_PEAR,
            ],
            [
                'mapValue' => '95e8062c-660b-44d7-8fc3-d56e1f6fbfde',
                'intoField' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT,
                'withValue' => DirectMarketerAttributes::VEGETABLES_AND_FRUIT_BERRY,
            ],
        ],
        'ab9e2a03-252b-4e9c-b278-082315b63408' => [
            [ 'intoField' => 'bakeryProdcuts' ],
        ],
        '2874d3e5-6f96-48b8-a087-0002e656f757' => [
            [ 'intoField' => GastronomyAttributes::ACCEPTED_PAYMENTS ],
        ],

        // wirhaltenzusammen Felder - not mapped yet
        '8030322c-9319-4532-b604-f146ae32b4a0' => [ [ 'intoField' => 'stayQuestionable' ] ],
        'e04db51b-5cec-4b66-bd36-28c886a82563' => [ [ 'intoField' => 'touristinfoOpen' ] ],
        '361f7175-bc59-4017-bd2c-c4977c0db2a0' => [ [ 'intoField' => 'tripCanceled' ] ],
        '2c4c9d9f-c4f6-429d-8c5c-e59de9512a1a' => [ [ 'intoField' => 'restrictionsPublicTransport' ] ],
        'bec44d15-7a02-4e61-9005-4d4a15610320' => [ [ 'intoField' => 'additionalInformationWebsite' ] ],
        '3d5c9779-bd21-4b85-9f31-11d2be978af9' => [ [ 'intoField' => 'websiteInformation' ] ],
        '8323ccb3-049c-4a7c-aaf5-4b497862c47c' => [ [ 'intoField' => 'shoppingInformation' ] ],
        '3f1a22eb-635b-4025-94e1-60a30fe92b50' => [ [ 'intoField' => 'shoppingArticles' ] ],
        '64933090-eb61-49d8-a136-4afc35597a30' => [ [ 'intoField' => 'gastroInformation' ] ],
        '2f8cb0b0-0f27-44bd-95c7-a18a98d7fff7' => [ [ 'intoField' => 'gastroArticles' ] ],
        'e05c2d2b-b64c-46d0-9c70-e13dee03b757' => [ [ 'intoField' => 'localStoreInformation' ] ],
        'c15c5355-a0a6-4b33-87f8-34a713c07779' => [ [ 'intoField' => 'localStoreArticles' ] ],
        '5d837e30-4155-406d-9f6b-db7261b39ae1' => [ [ 'intoField' => 'neighborhoodInformation' ] ],
        'dd376700-aeb7-4fd9-99f5-5fa088bb15d0' => [ [ 'intoField' => 'volunteers' ] ],
        '833e9ce3-d9b2-4b11-979a-864fabcc5bb6' => [ [ 'intoField' => 'digitalExperiences' ] ],
        '51dccd26-1b76-4320-a504-c6222c1aa8c8' => [ [ 'intoField' => 'digitalEvents' ] ],
        '61a42b02-c20d-4a06-9175-99e3a979cbd4' => [ [ 'intoField' => 'digitialOffers' ] ],
        '5e2bd87a-263d-4f58-87ff-772506e22731' => [ [ 'intoField' => 'sportInformation' ] ],
        'b94ba014-cb61-45d2-8b0c-4fe8c2a48217' => [ [ 'intoField' => 'sportArticles' ] ],
        'd31d9114-2adf-4b0f-8751-e72f3054ad22' => [ [ 'intoField' => 'pharmacyInformation' ] ],
        'f6004faa-abc7-4caa-8786-c1b9e16833c6' => [ [ 'intoField' => 'pharmacyArticles' ] ],
        'd002227f-fe84-416c-b38c-bda9d674b329' => [ [ 'intoField' => 'accommodationInformation' ] ],
        'd50104f7-b9b6-4a60-95c6-3c4e38adbfb9' => [ [ 'intoField' => 'accommodationArticles' ] ],

        // Gastronomy
        '7ff8e9bb-b87c-3c2f-a708-984cd0b39893' => [
            [
                'mapValue' => 'a7857ed3-45e4-4761-ad60-035586b66466',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_FRONTCOOKING,
            ],
            [
                'mapValue' => '48ae347a-8133-4da7-b0b0-4371fd6e8866',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_CATERING,
            ],
            [
                'mapValue' => 'c73b3fd2-ea14-4abf-b814-616f894675a6',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_TAKEAWAY,
            ],
        ],
        '16709ad6-c1d5-4339-86a9-29d85928462d' => [
            [
                'mapValue' => 'a29cb003-962a-442a-b37f-dd3fe72b9e49',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_BUS_PARKING,
            ],
            [
                'mapValue' => 'bb149ac3-5656-4917-8cf4-1af1c925544b',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_PARKING,
            ],
            [
                'mapValue' => 'bb149ac3-5656-4917-8cf4-1af1c925544b',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_PARKING,
            ],
            [
                'mapValue' => '413b225e-4089-46b5-9501-6fb85d4ac423',
                'intoField' => GenericArticleAttributes::SERVICES,
                'withValue' => GenericArticleAttributes::SERVICES_PUBLIC_TRANSIT,
            ],
        ],
        '7bb43561-5e99-3468-a68e-6123a87f522e' => [ [ 'intoField' => GastronomyAttributes::AMBIANCE ] ],
        'a455b6b5-8f03-3d02-a2a4-bad7c212655e' => [ [ 'intoField' => GastronomyAttributes::AMBIANCE ] ],
        'cc8e3e80-ee98-4db9-a218-191386306a0c' => [
            [
                'mapValue' => '88a6c0b5-813c-4e48-b6e0-814e271bb0f5',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_WELCOME,
            ],
            [
                'mapValue' => '88a6c0b5-813c-4e48-b6e0-814e271bb0f5',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_SUITABLE_FOR_FAMILIES,
            ],
            [
                'mapValue' => '0d148188-aa83-4884-841a-ec67fbf59d5a',
                'intoField' => PointOfInterestAttributes::INFORMATION,
                'withValue' => PointOfInterestAttributes::INFORMATION_SUITABLE_FOR_SENIORS,
            ],
        ],
        'b19b8bce-078a-4aaf-a802-b62f8d510d11' => [ [ 'intoField' => GastronomyAttributes::GROUPS ] ],
        'eb3d0644-8df5-310d-b4f0-2fef4690147e' => [
            [
                'mapValue' => 'da9585e8-88d0-4f9f-a00f-59d720891d65',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_MEAT,
            ],
            [
                'mapValue' => '03d14a83-4687-4497-83d9-07393dc3da6c',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_FISH,
            ],
            [
                'mapValue' => '98954b14-4a1a-45e1-961a-ab3a4e423fc9',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_REGIONAL,
            ],
            [
                'mapValue' => 'ca1523db-3290-40d2-a728-46a3a1a6da45',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_FONDUE,
            ],
            [
                'mapValue' => '283eeee8-922a-493c-b7b2-0660902d731c',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_REGIONAL,
            ],
            [
                'mapValue' => '53fd58d8-bbaa-4beb-95d4-07957b056871',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_SEASONAL,
            ],
            [
                'mapValue' => '2eeda29b-51a8-4235-bd2b-d93440e5b151',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_VEGETARIAN,
            ],
            [
                'mapValue' => '1a31c123-9c25-4fdd-9f6d-9e5c5358b546',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_CAKES,
            ],
            [
                'mapValue' => '901459a8-7ae3-4f65-a559-74d0d0ddcc31',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_ICE,
            ],
            [
                'mapValue' => '1408b929-eef5-4dec-a86a-41705068d9a6',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_BRUNCH,
            ],
            [
                'mapValue' => '2004f025-d3ff-4d08-8bad-eba0b216985f',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_STEAK,
            ],
            [
                'mapValue' => 'af29f57e-c3b1-41fa-bf94-91f8202414ab',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_COCKTAIL,
            ],
            [
                'mapValue' => '309d6926-6853-4912-8923-b741513c2bdd',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_WINE,
            ],
            [
                'mapValue' => '496bf93a-dc29-4bc8-9d7f-7152200f3536',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_MENU,
            ],
        ],
        'ebc7e6c2-87a3-3ebd-8cc0-3a31ce695a79' => [
            [
                'mapValue' => 'eff58bd4-50a3-465c-b32c-2d9ebd5d2ff5',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_BRUNCH,
            ],
            [
                'mapValue' => 'eabbab2f-59be-4be4-a951-c83a38213c29',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_LUNCH,
            ],
            [
                'mapValue' => '2c170664-727c-4173-b85f-5c4ab631d0d7',
                'intoField' => GastronomyAttributes::KITCHEN_STYLE,
                'withValue' => GastronomyAttributes::KITCHEN_STYLE_COFFEE_AND_CAKE,
            ],
        ],
        '4b3e7313-9856-3114-ba1f-ec637350aed5' => [
            [
                'mapValue' => '9781a4dd-4fd2-4d47-9104-53d1a82ee6e2',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_AFRICAN,
            ],
            [
                'mapValue' => '8b5632b8-9b78-4406-8253-f1bde1504e21',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_AMERICAN,
            ],
            [
                'mapValue' => 'c802234c-783d-4b06-94ae-7ef5f6901805',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_ARABIC,
            ],
            [
                'mapValue' => '72b7c987-faa8-4d95-b887-cba3f8a4871a',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_ASIAN,
            ],
            [
                'mapValue' => 'f47c4507-1958-405c-87c3-e4291a5d271d',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_FRENCH,
            ],
            [
                'mapValue' => 'dcd0b4e3-52f7-48a1-94f3-d8b6c6f2ee51',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_GREEK,
            ],
            [
                'mapValue' => 'c490c11b-6e6a-4d5c-b78c-4da6182935a4',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_HOMELY,
            ],
            [
                'mapValue' => '42cefd9c-5ff6-409a-92b4-5fcd8ae46754',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_HAUTE,
            ],
            [
                'mapValue' => '228b0b53-10d8-4063-987e-5eac6924483c',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_INDIAN,
            ],
            [
                'mapValue' => '767ff7e7-e4a9-4491-ba31-ef115c6ae0b7',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_INTERNATIONAL,
            ],
            [
                'mapValue' => '10783386-4a48-45c9-8f90-3d3536996af7',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_ITALIAN,
            ],
            [
                'mapValue' => '4c0a8bd4-d823-44f0-931d-ece7f61f72f8',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_JAPANESE,
            ],
            [
                'mapValue' => '6becd90b-d8fe-4a90-9896-d4a91c998a1d',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_MEDITERAN,
            ],
            [
                'mapValue' => 'ca5cb78d-8f8d-48c9-8911-2db21653ec59',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_MEXICAN,
            ],
            [
                'mapValue' => '2eb1792f-d680-4b6d-81d8-2391cc36c1eb',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_ORIENTAL,
            ],
            [
                'mapValue' => '29d7ff89-e173-42b9-8871-ad1de6399201',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_REGIONAL,
            ],
            [
                'mapValue' => '3dbb61f8-694c-4d37-baa7-fc9d8a07a19f',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_SPANISH,
            ],
            [
                'mapValue' => 'ae3c8b1b-6057-40b7-87b4-88fd2faec2c6',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_SWISS,
            ],
            [
                'mapValue' => '3cb1d9a9-936f-4e4a-935c-e5d03ccb964a',
                'intoField' => GastronomyAttributes::GASTRONOMY_STYLE,
                'withValue' => GastronomyAttributes::GASTRONOMY_STYLE_TURKISH,
            ],

        ],
        '2aabf283-c604-419c-a028-8124acaed13e' => [
            [
                'mapValue' => '6098b01e-2390-4af4-9f33-c6facf860e89',
                'intoField' => GastronomyAttributes::PRICE_SEGMENT,
                'withValue' => GastronomyAttributes::PRICE_SEGMENT_LOW,
            ],
            [
                'mapValue' => 'ce1fa7ef-cf32-46a8-866b-558c70a14cd6',
                'intoField' => GastronomyAttributes::PRICE_SEGMENT,
                'withValue' => GastronomyAttributes::PRICE_SEGMENT_MEDIUM,
            ],
            [
                'mapValue' => '3a634356-8aaa-4178-92d4-7ebf43316431',
                'intoField' => GastronomyAttributes::PRICE_SEGMENT,
                'withValue' => GastronomyAttributes::PRICE_SEGMENT_HIGH,
            ],
        ],
        'a7ce1770-af92-4996-a9a1-59b33bc47d2c' => [
            [ 'intoField' => GastronomyAttributes::SPOKEN_LANGUAGES ],
            [ 'intoField' => PointOfInterestAttributes::SPOKEN_LANGUAGES ],
        ],
        'b6bc37f1-f222-3bd6-91ae-536642e41b78' => [
            [
                'mapValue' => '09cc99ce-9eec-4dc7-a32e-33f821715f78',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_BIO,
            ],
            [
                'mapValue' => 'd3e1df62-27ab-41aa-a578-6413c9e3ba87',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_GLUTEN_FREE,
            ],
            [
                'mapValue' => 'acd1bc2d-81df-40f4-9b41-84eb4d81a2ff',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_HALAL,
            ],
            [
                'mapValue' => '30687939-7e10-489f-b661-2862fb3c06e3',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_KOSHER,
            ],
            [
                'mapValue' => '93e89210-190c-434f-8aca-036e817a89ba',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_LACTOSE_FREE,
            ],
            [
                'mapValue' => 'a7f0d959-ca3d-408a-b01c-ceef68aace0b',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_REDUCTION,
            ],
            [
                'mapValue' => '126b1b66-3a11-4aea-ac81-630d69a74172',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_SPECIAL_DIET,
            ],
            [
                'mapValue' => '62695123-a8fd-4d5e-a45c-3dd8b10a7dd8',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_VEGAN,
            ],
            [
                'mapValue' => '8e04c9c8-c71d-4785-9f75-fccc19c20e46',
                'intoField' => GastronomyAttributes::HABITS_ALLERGIES,
                'withValue' => GastronomyAttributes::HABITS_ALLERGIES_VEGETARIAN,
            ],
        ],

        // New fields?
        '35d3decf-4ebd-4879-a4bf-86e2993cb5c7' => [ [ 'intoField' => 'hotKitchen' ] ],
        '07959d3d-6705-4ffa-991a-7604d35a50bf' => [ [ 'intoField' => 'hotKitchenTime' ] ],
        '33c3fb63-11c8-33ea-a301-b9a4b8c06b41' => [ [ 'intoField' => 'outdoorTime' ] ],
        '01480042-3e62-47c6-b3e6-4af6cc7e18f0' => [ [ 'intoField' => 'seatsIndoor' ] ],
        '36ae8e69-5ccb-4624-bf20-8f7f088549b4' => [ [ 'intoField' => 'seatsOutdoor' ] ],
        '9bcbde72-6436-4535-a9f7-e1890b6e1bd5' => [ [ 'intoField' => 'numberAdjoiningRooms' ] ],
        '4244b0d0-92d8-4161-ad34-91ba16ab3db5' => [ [ 'intoField' => 'seatsAdjoiningRooms' ] ],
        'f276a27e-4673-445b-8a70-9f9254e20009' => [ [ 'intoField' => 'reservationsRecommended' ] ],
        'b5da896f-ab04-49ca-8a6a-b64e841862aa' => [ [ 'intoField' => 'onlineReservations' ] ],
        '8ea19f70-e9a0-4375-aa40-ca555877f0b2' => [ [ 'intoField' => 'groupSize' ] ],
        'c0e6de63-23db-4410-b001-784291059a63' => [ [ 'intoField' => 'groupsUpNumber' ] ],
        '99666a60-8667-4342-8c27-59fec22b61b0' => [ [ 'intoField' => 'houseLevelService' ] ],
        'ac70e71e-ec6d-4595-9c79-a2ce3d380b84' => [ [ 'intoField' => 'additionalEquipment' ] ],
        '71e78cc8-c3bf-4260-9f2a-6c21a910100f' => [ [ 'intoField' => 'ratingTrustYou' ] ],
        'f8f89c4e-2acc-4b7c-9c40-58b389a19821' => [ [ 'intoField' => 'ratingTripadvisor' ] ],
        '2d8e4736-44fa-4a24-a4b1-0302009880e1' => [ [ 'intoField' => 'location' ] ],
        '5e70c15d-dfbd-4a6d-9f2e-92cf44b2c56a' => [ [ 'intoField' => 'aboveSeaLevel' ] ],
        '0b6e557a-305c-46e3-8687-6149c0565954' => [ [ 'intoField' => 'distanceLake' ] ],
        '2c45dc15-0283-46bd-ba43-61797201a81b' => [ [ 'intoField' => 'discountTrail' ] ],
        '61662328-2b6e-4c54-823a-199badf3f612' => [ [ 'intoField' => 'distanceSlope' ] ],
        'b9678f29-74be-4736-b8f3-b69bbe3f6a5f' => [ [ 'intoField' => 'groupRooms' ] ],
        'e7d2b1ef-36ed-40ee-8559-afe450eb915c' => [ [ 'intoField' => 'conditionEquipment' ] ],
        '17810fe7-c546-4a10-b240-f05c214c081e' => [ [ 'intoField' => 'banquetSeating' ] ],
        '52a38a1f-1f6b-4895-8820-39aaafeab131' => [ [ 'intoField' => 'classroomSeating' ] ],
        '9b987797-f4e8-4d8a-91f2-adb267c3dbf0' => [ [ 'intoField' => 'theaterSeating' ] ],

        // #wirhaltenzusammen fields
        '8297a849-711a-478d-afe2-45b7cb6c5ba9' => [ [ 'intoField' => 'protectiveMeasures' ] ],
        '4b5a7232-44de-4d19-83e2-03b4537c2809' => [ [ 'intoField' => 'protectiveMeasuresMessage' ] ],
        '7ccb6c66-8b3b-4fc4-afc0-bbb250454621' => [ [ 'intoField' => 'differentContactInformation' ] ],
        '23eebea4-0b22-44a0-a52e-b77a6bfa387e' => [ [ 'intoField' => 'differentContactInformationText' ] ],
        '2dd96c0b-5470-40fd-8c53-17beb252e0fe' => [ [ 'intoField' => 'differentContactInformationPhone' ] ],
        '8a4f1b33-56eb-44b8-9e3f-4c8b0a63cc2a' => [ [ 'intoField' => 'differentContactInformationMail' ] ],
        'd8c29921-573e-4e35-896b-6688b8adf8ee' => [ [ 'intoField' => 'importantNews' ] ],
        '1ac91179-d7d2-4e27-8ea6-9090a7c23316' => [ [ 'intoField' => 'importantNewsTime' ] ],
        'b27a66b1-38ef-4f66-9d30-305400e23f61' => [ [ 'intoField' => 'importantNewsDate' ] ],
        '0aa4c85e-66c9-415f-8241-4b2868966ce9' => [ [ 'intoField' => 'houseOpen' ] ],
        '71c503a6-374e-48ec-96e6-0e6aedb28ac5' => [ [ 'intoField' => 'specialConditions' ] ],
        '8b2279b1-8467-4286-9f8e-3ad4e407dd97' => [ [ 'intoField' => 'pickupService' ] ],
        '9ffff586-546a-47c9-a686-04ee536ed44b' => [ [ 'intoField' => 'pickupServiceTime' ] ],
        '055c3723-8b35-44c6-b364-fd038b43d290' => [ [ 'intoField' => 'pickupProducts' ] ],
        '0e9836a6-e8ae-4fdd-875f-6b57c84f98f1' => [ [ 'intoField' => 'pickupDocuments' ] ],
        '777212c6-7daf-4f94-9a2f-9cc1b6c8a6b7' => [ [ 'intoField' => 'pickupWebsite' ] ],
        'c243b6c7-327f-4b72-8a7b-2e342a9478b5' => [ [ 'intoField' => 'pickupLocation' ] ],
        '0bb58f5c-263e-4aaa-90ae-0c291a8e23d3' => [ [ 'intoField' => 'deliveryService' ] ],
        '0a3bb0e4-3811-4319-b73a-e8edfcd9ee76' => [ [ 'intoField' => 'deliveryServiceTime' ] ],
        'f0cabaa5-558f-4a4b-ae7f-86f2d6d0ae13' => [ [ 'intoField' => 'deliveryProdcuts' ] ],
        'a2f5cc03-f777-4a0e-8cbf-458476fa09d3' => [ [ 'intoField' => 'deliveryDocuments' ] ],
        'e9725e2f-539f-46cb-ac4b-bf7f05672597' => [ [ 'intoField' => 'deliveryWebsite' ] ],
        '8f33d61b-528a-4d81-9157-2f1ed57a8707' => [ [ 'intoField' => 'deliveryLocation' ] ],
        '17f1d3fe-a2e8-4909-aa33-4ff0279d5a35' => [ [ 'intoField' => 'salesBooth' ] ],
        'e47ca277-30a4-485e-b68e-a0974ac8f0be' => [ [ 'intoField' => 'salesBoothTime' ] ],
        '3ef2feb5-e1c8-4418-903b-9bb936a7b85b' => [ [ 'intoField' => 'salesBoothProducts' ] ],
        'a48a9dad-ca76-431d-bc13-6207ad4f8745' => [ [ 'intoField' => 'salesBoothDocuments' ] ],
        '223cf451-9549-4ccc-8ed4-091c00767d9e' => [ [ 'intoField' => 'salesBoothWebsite' ] ],
        'f278ac22-88fc-4be3-af21-d6858c85cfa2' => [ [ 'intoField' => 'salesBoothLocation' ] ],
        '1843bfda-dd81-435f-b648-840f9d6f38ca' => [ [ 'intoField' => 'onlineSales' ] ],
        'ecf59f87-f6dc-42d7-bc9d-3c3d39e156e1' => [ [ 'intoField' => 'onlineSalesInformation' ] ],
        '35de5d83-02c0-487c-8319-bcc911c80314' => [ [ 'intoField' => 'onlineSalesWebsite' ] ],
        '01a6267d-22cc-4664-9207-20ff92fa4909' => [ [ 'intoField' => 'voucher' ] ],
        '0176afb5-8d54-41d4-8c1d-3341ace310e7' => [ [ 'intoField' => 'voucherInformation' ] ],
        '68b399e5-1f92-41d7-8caf-7dca5ce15974' => [ [ 'intoField' => 'voucherWebsite' ] ],

        // Lodging
        'dd6db60e-4241-4d4a-b820-f092417831b2' => [ [ 'intoField' => 'roomHomeOffice' ] ],
        'a0ccecf3-aea4-4bda-97b1-38e8b0a2147b' => [ [ 'intoField' => 'homeOfficeInformation' ] ],
        'a32b7354-df9d-45da-b408-fa70fc134bdf' => [ [ 'intoField' => 'voucherHouse' ] ],
        'f9221ec4-ac1c-4a8d-b411-d14350b7b111' => [ [ 'intoField' => 'voucherHouseInformation' ] ],
        '5372bfff-7eb9-4690-9a38-a5ce5eb30926' => [ [ 'intoField' => 'voucherHouseWebsite' ] ],
        'a32ca07d-2392-4b5a-ae62-21a94c0d1cd3' => [ [ 'intoField' => 'businessNights' ] ],
        '410a7b65-d48d-452c-8473-01355fb7cfc0' => [ [ 'intoField' => 'businessNightsInformation' ] ],

        // POI
        '23a57240-a86c-474b-87dd-d508cadc162b' => [ [ 'intoField' => PointOfInterestAttributes::INFORMATION ] ],
        'ba526659-5551-4ae5-b3ca-1c67f39da537' => [ [ 'intoField' => PointOfInterestAttributes::INFORMATION ] ],
        '12fe5348-1d93-4ccb-97f5-97ccaece5c0e' => [
            [ 'intoField' => PointOfInterestAttributes::FOR_KIDS ],
            [
                'mapValue' => 'e0820830-d699-4801-95cd-a1a0058342b1',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_PLAYGROUND,
            ],
            [
                'mapValue' => '8eaa8a30-896b-4499-b15a-82eb0452f9f7',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_PLAYGROUND,
            ],
            [
                'mapValue' => 'b2ba092a-e97f-4a35-b0a4-3f69bf8bcf40',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_CORNER,
            ],
            [
                'mapValue' => '37413c6a-c278-490d-8d6c-fa70f672a621',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_BOOKS,
            ],
            [
                'mapValue' => 'd1f34746-9807-48b8-9033-1459d6bb2696',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_PAINTING,
            ],
            [
                'mapValue' => '27d2f8e2-87a6-4069-b537-79793ecf89f0',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_TOYS,
            ],
            [
                'mapValue' => 'c5c9485d-fc0e-470e-83af-0106bd7b1e1c',
                'intoField' => GastronomyAttributes::FAMILIES,
                'withValue' => GastronomyAttributes::FAMILIES_CHANGING,
            ],
        ],

        '0f12a762-797b-4d19-9f0d-d4d41b384e7f' => [
            [
                'mapValue' => '2aa51c5d-ca0e-4e81-a6e9-2266fdf5ec4a',
                'intoField' => PointOfInterestAttributes::ACCESSIBLE_ISFORDEAFS,
                'withValue' => true,
            ],
            [
                'mapValue' => '559b1c08-f082-4b7c-8696-9e5e9260985b',
                'intoField' => PointOfInterestAttributes::ACCESSIBLE_ISFORBLINDS,
                'withValue' => true,
            ],
            [
                'mapValue' => 'a345d3f3-5487-4bb1-a852-6f44adeabad2',
                'intoField' => PointOfInterestAttributes::ACCESSIBLE_ISFORDISORDERS,
                'withValue' => true,
            ],
            [
                'mapValue' => '29c0aa38-00a7-4a60-88b8-426fb280947c',
                'intoField' => 'accessibleDIN',
            ],
            [
                'mapValue' => '125dffb1-ec83-455a-b5af-d84b963e12dc',
                'intoField' => 'accessiblePartially',
            ],
        ],

        '16641f4b-94c4-4cf2-b851-fa0c71b4ac9c' => [ [ 'intoField' => 'motorwayExit' ] ],
        'f5a45792-12c9-4dd5-bb38-2b736b471aa0' => [ [ 'intoField' => 'nextTrainStation' ] ],
        '0428c1c0-3362-4cca-98d6-b4268a0d5d74' => [ [ 'intoField' => 'publicTransportIn' ] ],

        '864ed3f4-da49-45b8-964a-07f8c0db6c44' => [
            [
                'mapValue' => '502b1280-e20a-461c-af84-e892eee9cafa',
                'intoField' => TourAttributes::PROPERTIES,
                'withValue' => TourAttributes::PROPERTIES_SUITABLE_FOR_PREAMBULATORS
            ],
            [
                'mapValue' => '6d5bde94-27e1-4442-ba75-a225d3908883',
                'intoField' => TourAttributes::PROPERTIES,
                'withValue' => TourAttributes::PROPERTIES_SUITABLE_FOR_WHEELCHAIRS
            ],
        ]
    ];

//    const AWARDS = [
//        'a572677f-cb0f-4b96-9ad4-97272d761940' => 'houseAwardsGeneral',
//        '2b74ea42-7897-4d5b-b291-09d81153048f' => 'houseAwardsGeneral',
//        'c1eefe36-9a9a-4591-9bb6-68646cec8fea' => 'houseAwardsAral',
//        '50bfcfe3-e13c-45d0-b2af-709536a12d77' => 'houseAwardsDehoga',
//        '2c129434-d34c-4d3e-8300-16013bcf0daf' => 'houseAwardsFine',
//        '470549d2-e59d-49eb-aba3-da428e720a88' => 'houseAwardsMichelin',
//        '615fe70f-796a-4554-8cb3-c2ea555e3d39' => 'houseAwardsMillau',
//        '44ff8483-f38a-4a41-846e-b89b73e00f4a' => 'houseAwardsVarta',
//        'c9f4d880-3475-4a49-a6f6-dbe58117c348' => 'houseAwardsMillauPoints',
//        'dd5fb02e-be79-4c51-96b8-e706c974caef' => 'houseAwardsGreen',
//        '57c44701-b05b-4775-8978-b0ac3bee0e76' => 'houseAwardsHTG',
//        '02c2396e-e5ce-480b-96af-86f2d8e55b7e' => 'houseAwardsSTG',
//    ];

    public function __construct(array $adaptee, int $type)
    {
        $this->type = $type;
        parent::__construct($adaptee);
    }

    public function getSourceSystem(): string
    {
        return self::SOURCE_TOUBIZ;
    }

    public function getMainType(): int
    {
        return $this->type;
    }

    public function getName(): string
    {
        return $this->object['name'];
    }

    public function getAbstract(): ?string
    {
        return $this->object['abstract'];
    }

    public function getDescription(): ?string
    {
        return $this->object['description'];
    }

    public function getLatitude(): ?float
    {
        return $this->object['point']['latitude']
            ?? $this->object['area']['latitude']
            ?? $this->extractGeometry()[0][0]
            ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->object['point']['longitude']
            ?? $this->object['area']['longitude']
            ?? $this->extractGeometry()[0][1]
            ?? null;
    }

    public function getMainAddress(): ?AddressAdapterInterface
    {
        $address = $this->object['point']['address']
            ?? $this->object['area']['address']
            ?? $this->object['relatedArticles']['tourContact'][0]['address']
            ?? null;

        if ($address) {
            $article = $this->object;
            $article['mainAddress'] = $address;
            return new MainAddressAdapter($article);
        }

        return null;
    }

    public function getAddresses(): array
    {
        $address = $this->getMainAddress();
        return $address ? [ $address ] : [];
    }

    public function getCategories(): array
    {
        // Indexing by id to prevent duplicate categories in primary & secondary
        $categories = [
            $this->object['primaryCategory']['id'] => $this->object['primaryCategory'],
        ];

        foreach ($this->object['secondaryCategories'] ?? [] as $item) {
            $categories[$item['id']] = $item;
        }

        return array_map(
            function ($item) {
                return new CategoryAdapter($item);
            },
            array_values($categories)
        );
    }

    public function getMedia(): array
    {
        $media = array_map(
            function ($item) {
                return new MediumAdapter($item);
            },
            $this->object['media'] ?? []
        );

        $youtubeVideo = YoutubeVideoAdapter::create($this->object['contactInformation']['youtubeVideo'] ?? null);
        if ($youtubeVideo) {
            $media[] = $youtubeVideo;
        }

        $vimeoVideo = VimeoVideoAdapter::create($this->object['contactInformation']['vimeoVideo'] ?? null);
        if ($vimeoVideo) {
            $media[] = $vimeoVideo;
        }

        return $media;
    }

    public function getMainMedium(): ?MediumAdapterInterface
    {
        $medium = $this->object['media'][0] ?? null;
        if (!$medium) {
            return null;
        }
        return new MediumAdapter($medium);
    }

    public function getFiles(): array
    {
        $files = array_map(
            function ($item) {
                return new FileAdapter($item);
            },
            $this->object['files'] ?? []
        );

        foreach ($this->object['tour']['gpsTracks'] ?? [] as $track) {
            $name = 'GPS-Track';
            if (strpos($track['file']['url'], '.gpx') !== false) {
                $name .= ' (GPX)';
            } elseif (strpos($track['file']['url'], '.kml') !== false) {
                $name .= ' (KML)';
            }

            $files[] = new FileAdapter($track['file'], $name);
        }

        return $files;
    }

    public function hasAttributes(): bool
    {
        return !empty($this->extractAttributes());
    }

    public function getAttributes(): array
    {
        return $this->extractAttributes();
    }

    public function getSourceName(): ?string
    {
        return $this->object['client']['name'] ?? null;
    }

    public function getAuthorName(): ?string
    {
        return $this->object['author'] ?? null;
    }

    public function getBookingUris(): array
    {
        return [];
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    public function getOpeningTimes(): ?string
    {
        $openingTimes = $this->object['openingTimes'] ?? null;
        if ($openingTimes) {
            return json_encode($openingTimes);
        }
        return null;
    }

    public function getOpeningTimesFormat(): ?string
    {
        $openingTimes = $this->object['openingTimes'] ?? null;
        return $openingTimes ? 'toubizV1' : null;
    }

    public function getAverageRating(): ?int
    {
        return null;
    }

    public function getNumberOfRatings(): ?int
    {
        return null;
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }

    private function extractAttributes(): array
    {
        $blueprints = [];
        $blueprintsToGroups = [];
        foreach ($this->object['fieldBlueprints'] as $group) {
            foreach ($group['fieldSets'] as $fieldSet) {
                foreach ($fieldSet['fields'] as $field) {
                    $blueprints[$field['id']] = $field;
                    $blueprintsToGroups[$field['id']] = $group['id'];
                }
            }
        }

        return array_merge(
            $this->getFixedAttributes(),
            $this->extractRegularAttributeMapping(),
            $this->extractAttributesFromMappedDynamicFields($blueprints),
            $this->extractAllDynamicFieldsByTheirId($blueprints, $blueprintsToGroups)
        );
    }

    private function extractRegularAttributeMapping(): array
    {
        $attributes = [];

        foreach (static::REGULAR_ATTRIBUTE_MAPPING as $attribute => $path) {
            $value = ArrayUtility::arrayGet($this->object, explode('.', $path));
            if (!$value) {
                continue;
            }

            $attributes[] = new AttributeAdapter(
                $attribute,
                $value,
                null,
                md5('nondynamic' . $this->getExternalId() . $attribute)
            );
        }

        return $attributes;
    }

    private function extractAttributesFromMappedDynamicFields(array $blueprints): array
    {
        $attributes = [ [] ];

        foreach ($blueprints as $fieldId => $blueprint) {
            $fieldValues = $this->object['fieldValues'][$fieldId] ?? [];
            $mappingConfigurations = static::DYNAMIC_FIELD_MAPPING[$fieldId] ?? null;

            if (empty($fieldValues) || !$mappingConfigurations) {
                continue;
            }

            foreach ($fieldValues as $fieldValue) {
                foreach ($mappingConfigurations as $mappingConfiguration) {
                    $attributes[] = $this->applyMappingConfiguration($mappingConfiguration, $fieldValue, $blueprint);
                }
            }
        }

        return array_merge(...$attributes);
    }

    private function extractAllDynamicFieldsByTheirId(array $blueprints, array $blueprintsToGroups): array
    {
        $attributes = [];

        foreach ($blueprints as $fieldId => $blueprint) {
            foreach ($this->object['fieldValues'][$fieldId] ?? [] as $fieldValue) {
                $mappedValue = $this->getValueOfDynamicField($blueprint, $fieldValue, false);
                foreach ((array) $mappedValue as $value) {
                    if (!$value) {
                        continue;
                    }

                    $attributes[] = new AttributeAdapter(
                        $fieldId,
                        $value,
                        $blueprintsToGroups[$fieldId] ?? null,
                        md5('raw' . $this->getExternalId() . $fieldId)
                    );
                }
            }
        }

        return $attributes;
    }

    private function applyMappingConfiguration(
        array $mappingConfiguration,
        array $fieldValue,
        array $blueprint
    ): array {
        $mapValue = $mappingConfiguration['mapValue'] ?? null;
        $rawValues = $this->getValueOfDynamicField($blueprint, $fieldValue, $mapValue === null);
        $intoField = (string) $mappingConfiguration['intoField'];

        $attributes = [];
        foreach ((array) $rawValues as $rawValue) {
            if (!$rawValue || ($mapValue && $rawValue !== $mapValue)) {
                continue;
            }

            $value = $mappingConfiguration['withValue'] ?? $rawValue;
            $attributes[] = new AttributeAdapter(
                $intoField,
                $value,
                null,
                md5('mapped' . $this->getExternalId() . $blueprint['id'] . $intoField)
            );
        }

        return $attributes;
    }

    /** @return string|float|bool|null */
    private function getValueOfDynamicField(array $blueprint, array $fieldValue, bool $humanReadable = true)
    {
        switch ($blueprint['type']) {
            case 'input':
            case 'textarea':
                $value = trim($fieldValue['value']['text'] ?? '') ?: null;
                break;

            case 'check':
                if ($humanReadable) {
                    $value = $fieldValue['humanReadableValue']['selected'] ?? [ ];
                } else {
                    $value = $fieldValue['value']['selected'] ?? [ ];
                }
                break;

            case 'select':
            case 'radio':
                if ($humanReadable) {
                    $value = $fieldValue['humanReadableValue']['selected'] ?? null;
                } else {
                    $value = $fieldValue['value']['selected'] ?? null;
                }
                break;

            default:
                if ($humanReadable) {
                    $value = ($fieldValue['humanReadableValue']['text'] ?? null)
                        ?: ($fieldValue['humanReadableValue']['selected'] ?? null)
                            ?: null;
                } else {
                    $value = ($fieldValue['value']['text'] ?? null)
                        ?: ($fieldValue['value']['selected'] ?? null)
                            ?: null;
                }
                break;
        }

        if (is_numeric($value)) {
            return (float) $value;
        }

        if ($value === 'Ja') {
            return true;
        }

        if ($value === 'Nein') {
            return false;
        }

        return $value;
    }

    private function extractGeometry(): array
    {
        if (!$this->cachedGeometry) {
            $gpsTrackUrl = $this->object['tour']['gpsTracks'][0]['file']['url'] ?? null;
            $gpsTrackPoints = $this->object['tour']['gpsTracks'][0]['file']['points'] ?? null;
            if (!empty($gpsTrackPoints)) {
                $this->cachedGeometry = $gpsTrackPoints;
            } elseif (is_string($gpsTrackUrl)) {
                $track = (new ParserFactory(new XmlFileReader()))
                    ->resolveParser($gpsTrackUrl)
                    ->extractTrack($gpsTrackUrl);

                if ($track->isEmpty()) {
                    $this->logger->warning(
                        sprintf(
                            'GPS File %s does not contain any track/point information.',
                            $gpsTrackUrl
                        )
                    );
                }

                $this->cachedGeometry = $track->mapPoints(
                    function (Point $point) {
                        return [ $point->getLatitude(), $point->getLongitude() ];
                    }
                );
            } else {
                $this->cachedGeometry = [];
            }
        }

        return $this->cachedGeometry;
    }

    private function getFixedAttributes(): array
    {
        $attributes = [
            $this->getGeometryAttribute(),
            $this->getPriceAttribute(),
            $this->getDurationAttribute(),
            $this->getDistanceAttribute(),
            $this->getTypeOfTourAttribute(),
            $this->getCapacityAttribute(),
        ];

        $attributes = array_merge(
            $attributes,
            $this->getRecommendedTimeOfTravelAttributes(),
            $this->getFixedPropertyAttributes()
        );
        return array_filter($attributes);
    }

    private function getFixedPropertyAttributes(): array
    {
        $attributes = [];

        $propertyMap = [
            'tour.scenic' => 'scenic',
            'tour.geology' => 'geology',
            'tour.fauna' => 'fauna',
            'tour.flora' => 'flora',
            'tour.culture' => 'culture',
        ];

        foreach ($propertyMap as $key => $value) {
            if (ArrayUtility::arrayGet($this->object, explode('.', $key))) {
                $attributes[] = new AttributeAdapter(
                    TourAttributes::PROPERTIES,
                    $value,
                    null,
                    $this->getExternalId() . '_fixed_property_' . $key
                );
            }
        }

        return $attributes;
    }

    private function monthToConstant(string $month): ?string
    {
        switch ($month) {
            case 'january':
                return MonthConstants::JANUARY;
            case 'february':
                return MonthConstants::FEBRUARY;
            case 'march':
                return MonthConstants::MARCH;
            case 'april':
                return MonthConstants::APRIL;
            case 'may':
                return MonthConstants::MAY;
            case 'june':
                return MonthConstants::JUNE;
            case 'july':
                return MonthConstants::JULY;
            case 'august':
                return MonthConstants::AUGUST;
            case 'september':
                return MonthConstants::SEPTEMBER;
            case 'october':
                return MonthConstants::OCTOBER;
            case 'november':
                return MonthConstants::NOVEMBER;
            case 'december':
                return MonthConstants::DECEMBER;
            default:
                return null;
        }
    }

    /**
     * @inheritDoc
     */
    public function getCitySelectors(): array
    {
        return array_map(
            function (array $item) {
                return new ExternalIdSelector(ExternalIdType::TOUBIZ, $item['id']);
            },
            $this->object['relatedArticles']['areas'] ?? []
        );
    }

    /**
     * @inheritDoc
     */
    public function getAdditionalExternalIds(): array
    {
        $ids = [
            new ExternalIdAdapter(ExternalIdType::TOUBIZ, $this->getExternalId()),
        ];

        $toubizLegacyRemoteId = null;
        $toubizLegacyId = null;
        foreach ($this->object['externalIds'] ?? [] as $service => $id) {
            [ $service, $mappedId ] = $this->mapExternalIdService($service, $id);
            $ids[] = new ExternalIdAdapter($service, $mappedId);

            if ($service === ExternalIdType::TOUBIZ_LEGACY) {
                $toubizLegacyId = $id;
            } elseif ($service === ExternalIdType::TOUBIZ_LEGACY_REMOTE_ID) {
                $toubizLegacyRemoteId = $id;
            }
        }

        if ($toubizLegacyId !== null && $toubizLegacyRemoteId === null) {
            $remoteId = $this->guessRemoteIdBasedOnPrefixedToubizLegacyId((string) $toubizLegacyId);
            if ($remoteId) {
                $ids[] = new ExternalIdAdapter(ExternalIdType::TOUBIZ_LEGACY_REMOTE_ID, $remoteId);
            }
        }

        return $ids;
    }

    private function mapExternalIdService(string $service, string $id): array
    {
        switch ($service) {
            case 'toubizLegacy':
            case 'toubizId':
                $parts = explode('.', $id);
                $id = (string) array_pop($parts);
                return [ ExternalIdType::TOUBIZ_LEGACY, $id ];
            case 'toubizLegacyRemoteId':
                return [ ExternalIdType::TOUBIZ_LEGACY_REMOTE_ID, $id ];
            case 'outdoorActiveId':
                return [ ExternalIdType::OUTDOORACTIVE, $id ];
            case 'tomasId':
                return [ ExternalIdType::TOMAS, $id ];
            default:
                return [ $service, $id ];
        }
    }

    /**
     * Sometimes, no original id was saved on articles.
     * This method tries to guess the correct remote_id based on the prefixes in the toubiz id.
     *
     * @see https://newland.atlassian.net/wiki/spaces/INFOSYSTEM/pages/1524072466/External+IDs
     */
    private function guessRemoteIdBasedOnPrefixedToubizLegacyId(string $id): ?string
    {
        $parts = explode('.', $id);
        $id = (string) array_pop($parts);
        $prefix = implode('.', $parts);

        switch ($prefix) {
            case 'g':
                return 'tbgastro_' . $id;
            case 'd':
                return 'tbdirekt_' . $id;
            case 'city':
                return 'location_' . $id;
            case 'poi':
            case 'tour':
            default:
                // No common prefix exists
                return null;
        }
    }

    public function getFacebookUri(): ?string
    {
        return ($this->object['contactInformation']['facebook'] ?? null) ?: null;
    }

    public function getTwitterUri(): ?string
    {
        return ($this->object['contactInformation']['twitter'] ?? null) ?: null;
    }

    public function getInstagramUri(): ?string
    {
        return ($this->object['contactInformation']['instagram'] ?? null) ?: null;
    }

    public function getYoutubeUri(): ?string
    {
        return ($this->object['contactInformation']['youtube'] ?? null) ?: null;
    }

    public function getWikipediaUri(): ?string
    {
        return ($this->object['contactInformation']['wikipedia'] ?? null) ?: null;
    }

    public function getFlickrUri(): ?string
    {
        return ($this->object['contactInformation']['flickr'] ?? null) ?: null;
    }


    private function getGeometryAttribute(): ?AttributeAdapterInterface
    {
        $geometry = $this->extractGeometry();

        if (!empty($geometry)) {
            return new AttributeAdapter(
                TourAttributes::GEOMETRY,
                $geometry,
                null,
                $this->getExternalId() . '__geometry'
            );
        }

        return null;
    }

    private function getPriceAttribute(): ?AttributeAdapterInterface
    {
        $currencies = $this->object['point']['price']['currencies'] ?? [];
        $priceGroups = $this->object['point']['price']['priceGroups'] ?? [];
        if (empty($priceGroups)) {
            return null;
        }

        $table = [];
        foreach ($priceGroups as $priceGroup) {
            foreach ($priceGroup['priceEntries'] ?? [] as $priceEntry) {
                $row = [ $priceGroup['title'], $priceEntry['title'] ];
                foreach ($currencies as $currency) {
                    if ($currency === 'eur') {
                        $row[] = sprintf('%.2f €', $priceEntry['eur']);
                    } elseif ($currency === 'chf') {
                        $row[] = sprintf('CHF %.2f', $priceEntry['eur']);
                    } else {
                        $row[] = sprintf('%s %.2f', $currency, $priceEntry[$currency]);
                    }
                }
                $row[] = $priceEntry['comment'];
                $table[] = $row;
            }
        }

        return new AttributeAdapter(
            PointOfInterestAttributes::PRICES,
            $table,
            null,
            $this->getExternalId() . '__prices'
        );
    }

    private function getRecommendedTimeOfTravelAttributes(): array
    {
        $recommendedTimeOfTravel = $this->object['tour']['recommendedTimeOfTravel'] ?? null;
        if (!$recommendedTimeOfTravel) {
            return [];
        }

        $attributes = [];
        foreach ($recommendedTimeOfTravel as $month => $recommended) {
            if (!$recommended) {
                continue;
            }

            $attributes[] = new AttributeAdapter(
                TourAttributes::BEST_SEASON,
                $this->monthToConstant($month),
                null,
                $this->getExternalId() . '__best-season__' . $month
            );
        }
        return $attributes;
    }

    private function getDurationAttribute(): ?AttributeAdapterInterface
    {
        $duration = $this->object['tour']['combinedTrackInformation']['duration'] ?? null;
        if ($duration) {
            return new AttributeAdapter(
                TourAttributes::TOUR_DURATION,
                $duration,
                null,
                $this->getExternalId() . '__duration'
            );
        }

        // TODO Remove old hours handling
        $hours = $this->object['tour']['combinedTrackInformation']['hours'] ?? null;
        if ($hours) {
            return new AttributeAdapter(
                TourAttributes::TOUR_DURATION,
                $hours * 60,
                null,
                $this->getExternalId() . '__duration'
            );
        }

        return null;
    }

    private function getDistanceAttribute(): ?AttributeAdapterInterface
    {
        $distance = $this->object['tour']['combinedTrackInformation']['distance'] ?? null;
        if ($distance) {
            return new AttributeAdapter(
                TourAttributes::TOUR_LENGTH,
                $distance,
                null,
                $this->getExternalId() . '__distance'
            );
        }

        // TODO Remove old kilometers handling
        $kilometers = $this->object['tour']['combinedTrackInformation']['kilometers'] ?? null;
        if ($kilometers) {
            return new AttributeAdapter(
                TourAttributes::TOUR_LENGTH,
                $kilometers * 1000,
                null,
                $this->getExternalId() . '__distance'
            );
        }

        return null;
    }

    private function getCapacityAttribute(): ?AttributeAdapterInterface
    {
        $dynamicFieldIds = [
            'inside' => '01480042-3e62-47c6-b3e6-4af6cc7e18f0',
            'outside' => '36ae8e69-5ccb-4624-bf20-8f7f088549b4',
            'sideRooms' => '4244b0d0-92d8-4161-ad34-91ba16ab3db5',
        ];

        $data = [];
        foreach ($dynamicFieldIds as $fieldName => $fieldId) {
            $data[$fieldName] = $this->object['fieldValues'][$fieldId][0]['humanReadableValue']['text'] ?? null;
        }

        $formats = [
            'inside' => [
                'de' => 'Innen: %s',
                'en' => 'inside: %s',
            ],
            'outside' => [
                'de' => 'Außen: %s',
                'en' => 'outside: %s',
            ],
            'sideRooms' => [
                'de' => 'In Nebenräumen: %s',
                'en' => 'In siderooms: %s',
            ],
        ];

        $formatted = [];
        foreach ($data as $field => $value) {
            if ($value) {
                $formatted[] = sprintf($formats[$field][$this->language] ?? $formats[$field]['en'], $value);
            }
        }

        if (empty($formatted)) {
            return null;
        }

        return new AttributeAdapter(
            GastronomyAttributes::CAPACITY,
            implode(', ', $formatted),
            null,
            $this->object['id'] . '__capacity'
        );
    }

    private function getTypeOfTourAttribute(): ?AttributeAdapterInterface
    {

        $typeOfTour = $this->object['tour']['typeOfTour'] ?? null;
        $mappedTypeOfTour = null;
        switch ($typeOfTour) {
            case 'loop_tour':
                $mappedTypeOfTour = 'loopTour';
                break;
            case 'one_way_tour':
                $mappedTypeOfTour = 'oneWayTour';
                break;
            case 'stage':
                $mappedTypeOfTour = 'stage';
                break;
            case 'stages_tour':
                $mappedTypeOfTour = 'multiStageTour';
                break;
            case 'mountaintop_tour':
                $mappedTypeOfTour = 'mountainTopTour';
                break;
            case 'multi_day_tour':
                $mappedTypeOfTour = 'multiDayTour';
                break;
        }
        if ($mappedTypeOfTour) {
            return new AttributeAdapter(
                TourAttributes::PROPERTIES,
                $mappedTypeOfTour,
                null,
                $this->getExternalId() . '__type-of-tour'
            );
        }

        return null;
    }

    /**
     * Safeguard from importing untranslated articles that have been accidentally fetched.
     * This can happen because at the moment toubiz will return all articles, even untranslated ones
     * when requesting a translated list.
     *
     * This method should not be required once the following PR has been merged & deployed:
     * https://bitbucket.org/landinsicht/toubiz/pull-requests/982/bugfix-do-not-list-untranslated-articles
     */
    public function ignoreRecord(): bool
    {
        return !\in_array($this->language, $this->object['languages'], true);
    }

    public function getZipCodes(): array
    {
        return $this->object['area']['zipCodes'] ?? [ ];
    }

    public function getIdToubiz(): string
    {
        return $this->object['externalIds']['toubizLegacyRemoteId']
            ?? $this->object['externalIds']['toubizLegacyId']
            ?? '';
    }

    public function getIdTomas(): string
    {
        return $this->object['externalIds']['tomasId'] ?? '';
    }

    public function getClaim(): string
    {
        return $this->object['area']['claim'] ?? '';
    }

    public function getFacts(): string
    {
        return $this->object['area']['claim'] ?? 'facts';
    }

    public function getWebcamUrl(): ?string
    {
        return $this->object['contactInformation']['webcam'] ?? null;
    }

    public function getWebcamDescription(): ?string
    {
        return null;
    }

    public function getNews(): ?string
    {
        return null;
    }
}
