<?php declare(strict_types=1);
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Article adapter interface.
 *
 * Defines the interface for all article adapters
 * representing an article.
 */
interface ArticleAdapterInterface extends ObjectAdapterInterface
{
    public const SOURCE_TOUBIZ = 'toubiz';
    public const SOURCE_TOUBIZ_LEGACY = 'toubiz_legacy';
    public const SOURCE_OUTDOORACTIVE = 'outdoor_active';
    public const SOURCE_TPORTAL = 'tportal';

    public function getSourceSystem(): string;

    /**
     * Returns the main type of the article.
     *
     * This is used for filtering records.
     *
     * @see Concern\ArticleConstants
     * @return int
     */
    public function getMainType(): int;

    public function getName(): string;

    public function getAbstract(): ?string;

    public function getDescription(): ?string;

    public function getLatitude(): ?float;

    public function getLongitude(): ?float;

    public function getMainAddress(): ?AddressAdapterInterface;

    /**
     * @return AddressAdapterInterface[]
     */
    public function getAddresses(): array;

    /**
     * @return CategoryAdapterInterface[]
     */
    public function getCategories(): array;

    /**
     * @return MediumAdapterInterface[]
     */
    public function getMedia(): array;

    /**
     * The main medium. Used for teasers, etc.
     *
     * @return MediumAdapterInterface|null
     */
    public function getMainMedium(): ?MediumAdapterInterface;

    /**
     * @return FileAdapterInterface[]
     */
    public function getFiles(): array;

    /**
     * TODO Remove method. The same data can be retrieved form `getAttributes`
     * @deprecated
     * @return bool
     */
    public function hasAttributes(): bool;

    /**
     * @return AttributeAdapterInterface[]
     */
    public function getAttributes(): array;

    public function getSourceName(): ?string;

    public function getAuthorName(): ?string;

    /** @return UriAdapterInterface[] */
    public function getBookingUris(): array;

    /**
     * Returns the URI for an external detail page.
     *
     * @return string|null
     */
    public function getDetailUri(): ?string;

    /**
     * The complete, encoded opening times data.
     *
     * @return string|null
     */
    public function getOpeningTimes(): ?string;

    /**
     * The format of the opening times string.
     * @see \Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants for values.
     *
     * @return string|null
     */
    public function getOpeningTimesFormat(): ?string;

    /**
     * Return the average rating on a scale of 0-100
     *
     * @return int|null
     */
    public function getAverageRating(): ?int;

    /**
     * Return the number of ratings.
     *
     * @return int|null
     */
    public function getNumberOfRatings(): ?int;

    /**
     * Returns the record language of the article as one of the Langauge::* constants
     * or `null` if the record is not translatable.
     *
     * @return string|null
     */
    public function getLanguage(): ?string;
}
