<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Constants\Language;

trait LanguageAware
{
    /**
     * @var string|null
     */
    protected $language;

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function setLanguage(?string $language): void
    {
        Language::throwIfInvalid($language);
        $this->language = $language;
    }
}
