<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use function Safe\preg_replace;

class AttributeMap
{
    /** @var string[][] */
    private static $map = [];

    /** @return string[][] */
    public static function get(): array
    {
        if (!empty(static::$map)) {
            return static::$map;
        }

        $handle = fopen(__DIR__ . '/../../../../../Resources/Service/Toubiz/ApiV1/Mapping.csv', 'rb');

        $inMap = [];
        // phpcs:ignore Generic.CodeAnalysis.AssignmentInCondition.FoundInWhileCondition
        while ($row = fgetcsv($handle)) {
            $stringified = preg_replace('/\s/', '', implode('|', $row));
            if ($inMap[$stringified] ?? false) {
                continue;
            }
            static::$map[] = $row;
            $inMap[$stringified] = true;
        }
        fclose($handle);

        return static::$map;
    }
}
