<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Lodging adapter.
 *
 * This represents an Article with mapping for the Tportal lodging.
 *
 * @Flow\Scope("singleton")
 */
class LodgingAdapter extends AbstractLegacyObjectAdapter implements ArticleAdapterInterface
{
    /**
     * @return int
     */
    public function getMainType()
    {
        return ArticleConstants::TYPE_LODGING;
    }

    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['housedata']['out']['ID'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        $name = $this->object['housedata']['out']['sortName'];
        if (empty($name)) {
            $name = $this->object['housedata']['out']['address']['personFirstName'];
            $name .= ' ';
            $name .= $this->object['housedata']['out']['address']['personLastName'];
        }
        if (empty(trim($name))) {
            $name = $this->object['housedata']['out']['describingName'];
        }
        return $name;
    }

    /**
     * @return string|null
     */
    public function getAbstract()
    {
        // Currently, there is no abstract.
        return;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        $part = $this->object['housedata']['out']['descriptions'];
        if ($part) {
            if (array_key_exists('description', $part)) {
                return $part['description'];
            } else {
                $descriptionPart = $this->findInArray(
                    $part,
                    'descriptionTypeName',
                    'Beschreibung'
                );

                if ($descriptionPart && !empty($descriptionPart['description'])) {
                    return $descriptionPart['description'];
                }
            }
        }
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['housedata']['out']['address']['street'];
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->object['housedata']['out']['address']['zipCode'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->object['housedata']['out']['address']['city'];
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->object['housedata']['out']['address']['country']['name'];
    }

    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->object['housedata']['out']['address']['gmapsLatitude'];
    }

    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->object['housedata']['out']['address']['gmapsLongitude'];
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        if (empty($this->object['housedata']['out']['touristicType'])) {
            return [];
        }

        return [
            (new CategoryAdapter($this->object['housedata']['out']['touristicType']))
        ];
    }

    /**
     * @return array
     */
    public function getAddresses()
    {
        return [];
    }
    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        if (empty($this->object['housedata']['out']['multimediaURLs'])) {
            return [];
        }

        foreach ($this->object['housedata']['out']['multimediaURLs'] as $item) {
            /*
             * Right now, only the preview image is being imported as there is
             * no show view for lodgings.
             */
            if ($item['type']['value'] == 'TP_Preview') {
                return [(new MediumAdapter($item))];
            }
        }
        return [];
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        $attributes = [];

        if (!empty($this->object['searchresult_details']['services'])) {
            $currency = $this->object['searchresult_details']['services'][0]['minimumBasePrice']['currency'];
            $unit = $this->object['searchresult_details']['services'][0]['minimumBasePriceCalculationRule'];
            $value = $this->object['searchresult_details']['services'][0]['minimumBasePrice']['value'];

            if ($currency && $unit && $value) {
                $attributes['minimumBasePrice'] = [
                    'currency' => $currency,
                    'unit' => $unit,
                    'value' => $value
                ];
            }
        }

        return $attributes;
    }

    /**
     * @return array
     */
    public function getFiles()
    {
        return [];
    }

    /**
     * @return string|null
     */
    public function getFacebookUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getTwitterUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getInstagramUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getYoutubeUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getSourceName()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getAuthorName()
    {
        return;
    }

    /**
     * @return string
     */
    public function getBookingUri()
    {
        return;
    }
}
