<?php
namespace Newland\Toubiz\Api\Service\Sisag\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\SlopeAdapterInterface;

/**
 * Slope object adapter.
 *
 * Describes a slope for skiing, sledding.
 *
 * Types and difficulties are in the same TYPNAME node but are split up here.
 */
class SlopeAdapter extends AbstractObjectAdapter implements SlopeAdapterInterface
{
    /**
     * Mapping of string types to interface types.
     *
     * @var array
     */
    const TYPE_MAPPING = [
        'Skipiste'         => self::TYPE_SKI,
        'variante'         => self::TYPE_FREERIDE,
        'Fun'              => self::TYPE_FUN,
        'LanglaufKl'       => self::TYPE_CROSS_COUNTRY_SKIING,
        'LanglaufNacht'    => self::TYPE_CROSS_COUNTRY_SKIING,
        'LanglaufSk'       => self::TYPE_CROSS_COUNTRY_SKIING_SKATING,
        'Schlitteln'       => self::TYPE_SLED_TRAIL,
        'Wanderweg'        => self::TYPE_HIKING_TRAIL,
        'Schneeschuhtrail' => self::TYPE_SNOWSHOE_HIKING_TRAIL
    ];

    /**
     * @var array Mapping of string difficulties to interface difficulties.
     */
    const DIFFICULTY_MAPPING = [
        'leicht' => self::DIFFICULTY_EASY,
        'mittel' => self::DIFFICULTY_MEDIUM,
        'schwer' => self::DIFFICULTY_HARD
    ];

    /**
     * @return string
     */
    public function getExternalId()
    {
        return (string)$this->object->ID;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return (string)$this->object->NAME;
    }

    /**
     * @return string
     */
    public function getRegion()
    {
        return (string)$this->object->REGION['id'];
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return (int)$this->object->STATUS;
    }

    /**
     * @return int|null
     */
    public function getType()
    {
        $name = (string)$this->object->TYPNAME;
        if (array_key_exists($name, self::TYPE_MAPPING)) {
            return self::TYPE_MAPPING[$name];
        }
    }

    /**
     * @return int|null
     */
    public function getDifficulty()
    {
        $name = (string)$this->object->TYPNAME;
        if (array_key_exists($name, self::DIFFICULTY_MAPPING)) {
            return self::DIFFICULTY_MAPPING[$name];
        }
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        $timezone = (new \DateTimeZone('Europe/Zurich'));
        return \DateTime::createFromFormat(
            'd.m.Y H:i',
            (string)$this->object->AUSGABE,
            $timezone
        );
    }
}
