<?php
namespace Newland\Toubiz\Api\Service\Meteotest;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;

/**
 * Service for Meteotest API.
 */
class ApiService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://mdx.meteotest.ch/';

    /**
     * @var string Action name for the API endpoint.
     */
    protected $action;

    /**
     * @param string $action
     * @return void
     */
    public function setAction($action)
    {
        $this->action = $action;
    }

    /**
     * Fetches forecast.
     *
     * @return mixed
     */
    public function fetchForecast()
    {
        $parameters = [
            ':apiKey' => $this->apiKey,
            ':action' => $this->action
        ];

        $uri = str_replace(
            array_keys($parameters),
            array_values($parameters),
            self::BASE_URI . 'api_v1?key=:apiKey&service=prod2data&action=:action&format=json'
        );

        $response = $this->httpClient->request('GET', $uri);
        if ($response->getStatusCode() == 200) {
            $data = json_decode($response->getBody(), true);
            return $data['payload']['mos'];
        } else {
            return false;
        }
    }
}
