<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Concern\SlopeConstants;

/**
 * Slope adapter interface.
 *
 * Defines the interface for slope adapters
 * representing a snow slope.
 */
interface SlopeAdapterInterface extends ObjectAdapterInterface, SlopeConstants
{
    /**
     * Returns the name.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the region.
     *
     * @return string
     */
    public function getRegion();

    /**
     * Returns the status.
     *
     * @return integer
     */
    public function getStatus();

    /**
     * Returns the type.
     *
     * @return integer
     */
    public function getType();

    /**
     * Returns the difficulty.
     *
     * @return integer
     */
    public function getDifficulty();
}
