<?php

namespace Newland\Toubiz\Api\Utility;

/**
 * Date Interval with some additional formatting options.
 * Note: This class does not try to be 100% accurate in all situations.
 *       Months are approximated to be 30 days long and years are approximated
 *       to be 365 days long. Differences in month length, leap years and leap
 *       seconds are ignored.
 */
class TimeDelta extends \DateInterval
{
    protected const MINUTES_TO_SECONDS = 60;
    protected const HOURS_TO_SECONDS = 60 * self::MINUTES_TO_SECONDS;
    protected const DAYS_TO_SECONDS = 24 * self::HOURS_TO_SECONDS;
    protected const MONTHS_TO_SECONDS = 30 * self::DAYS_TO_SECONDS;
    protected const YEARS_TO_SECONDS = 365 * self::DAYS_TO_SECONDS;

    public static function create(string $format): self
    {
        try {
            $interval = static::createFromDateString($format);
            $emptyInterval = $interval->y === 0
                && $interval->m === 0
                && $interval->d === 0
                && $interval->h === 0
                && $interval->i === 0
                && $interval->s === 0;

            if (!$emptyInterval) {
                $format = $interval->format('P%yY%mM%dDT%HH%iM%sS');
            }
            // phpcs:ignore
        } catch (\Exception $e) {
            // Error is ignored.
        }

        $format = strtoupper($format);

        // Prepend 'P' or 'PT' to transform something like '2d' to a valid
        // date ISO8601-ish format
        if ($format{0} !== 'P') {
            $prefix = strpos($format, 'T') === false ? 'PT' : 'P';
            $format = $prefix . $format;
        }

        return new static($format);
    }

    public function asSeconds(): int
    {
        return $this->s
            + $this->i * self::MINUTES_TO_SECONDS
            + $this->h * self::HOURS_TO_SECONDS
            + $this->d * self::DAYS_TO_SECONDS
            + $this->m * self::MONTHS_TO_SECONDS
            + $this->y * self::YEARS_TO_SECONDS;
    }
}
