<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

use GuzzleHttp\Promise\PromiseInterface;
use GuzzleHttp\Psr7\Uri;
use Newland\Toubiz\Api\Constants\Language;
use Newland\Toubiz\Api\Service\ServiceResult;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMapParser;
use function Safe\sprintf;

trait SharedLegacyToubizServiceBehaviour
{
    protected $categoryMapCsv = '/../../../../Resources/Service/Toubiz/Legacy/DbService/categories.csv';

    /**
     * Map of language constants to URI segments expected by the API.
     *
     * @var array
     */
    protected static $languageMap = [
        Language::DE => 'ger-DE',
        Language::EN => 'eng-GB',
        Language::FR => 'fre-FR',
        Language::ES => 'esl-ES',
        Language::IT => 'ita-IT',
    ];

    protected function buildUrl(array $parameters): string
    {
        $parameters['key'] = $parameters['key'] ?? $this->apiKey;

        $url = '/layout/set/json/content/view/json/' . $this->clientName;

        foreach ($parameters as $key => $value) {
            $url .= sprintf('/(%s)/%s', $key, $value);
        }

        if ($this->language) {
            $url .= '/(lang)/' . static::$languageMap[$this->language];
        }

        return $url;
    }

    protected function fetchListOfAllExistingObjectsAsServiceResult(string $class): PromiseInterface
    {
        $url = $this->buildUrl([ 'class' => $class, 'getremoteids' => '1' ]);
        return $this->jsonRequest(new Uri($url), 5)->then(function (array $data) {
            $result = new ServiceResult();
            $result->setAll($data['content']['children']);
            $result->setDeleted($data['content']['hidden']);
            return $result;
        });
    }

    /**
     * The category map is built from a static csv export from Toubiz Legacy.
     * This should be updated when new categories are added in Toubiz Legacy Backend.
     */
    protected function getCategoryMap(): CategoryMap
    {
        $file = __DIR__ . $this->categoryMapCsv;
        return (new CategoryMapParser())->parse($file, (string) $this->language);
    }
}
