<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Region adapter interface.
 *
 * Defines the interface for region adapters
 * representing a region.
 */
interface RegionAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the name of this region.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns an array of various attributes.
     *
     * @return array
     */
    public function getAttributes();

    /**
     * Returns a DateTime object of the last update.
     *
     * @return \DateTime
     */
    public function getUpdatedAt();
}
