<?php declare(strict_types=1);
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Exception\UnsupportedLanguageException;
use function Safe\file;

class CategoryMapParser
{
    const DEFAULT_LANGUAGE = 'de';

    /** @var string */
    private $language = '';

    public function parse(string $csvPath, string $language): CategoryMap
    {
        $this->language = $language;
        $map = [];

        $rows = file($csvPath);

        // parse column names for requested language
        $columnNames = str_getcsv($rows[0], ';');
        $languageIndex = $this->getLanguageIndex($columnNames);

        // remove column names
        array_shift($rows);

        foreach ($rows as $row) {
            $values = str_getcsv($row, ';');
            $map[$values[1]] = $values[$languageIndex];
        }

        return new CategoryMap($map);
    }

    private function getLanguageIndex(array $columnNames): int
    {
        $languageIndex = array_search($this->language, $columnNames, true);
        if ($languageIndex === false) {
            $languageIndex = array_search(self::DEFAULT_LANGUAGE, $columnNames, true);
        }

        if ($languageIndex === false) {
            throw new UnsupportedLanguageException(
                'Unsupported language for static category mapping: ' . $this->language,
                1556549106
            );
        }

        return $languageIndex;
    }
}
