<?php
namespace Newland\Toubiz\Api\Constants;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

abstract class Enum
{
    /**
     * @var array
     */
    protected static $constants = [];

    public static function validValue($value): bool
    {
        return \in_array($value, static::values(), true);
    }

    public static function throwIfInvalid($value, $exception = \InvalidArgumentException::class): void
    {
        if (static::validValue($value)) {
            return;
        }

        throw new $exception(
            sprintf(
                '%s "%s" is not valid. Valid values: %s',
                static::name(),
                (string) $value,
                implode(', ', static::values())
            )
        );
    }

    public static function name(): string
    {
        $parts = explode('\\', static::class);
        return (string) array_pop($parts);
    }

    public static function values(): array
    {
        self::extractConstants();
        return array_values(static::$constants[static::class]);
    }

    private static function extractConstants(): void
    {
        if (static::$constants[static::class] ?? null) {
            return;
        }

        static::$constants[static::class] = (new \ReflectionClass(static::class))->getConstants();
    }
}
