<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['id']);
    }

    public function getSourceUri(): string
    {
        return strip_tags((string) $this->object['reference']);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['copyright'] ?? null;
        return $copyright ? strip_tags((string) $copyright) : null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['title'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getPreviewUri(): ?string
    {
        return null;
    }
}
