<?php
namespace Newland\Toubiz\Api\Service\GeoLocation;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use GuzzleHttp\Client;

class NominatimService implements GeoLocationServiceInterface
{
    const BASE_URL = 'https://nominatim.openstreetmap.org/reverse';

    public function getZipFromGeoLocation(float $lat = null, float $lon = null): string
    {
        $zip = '';

        if ($lat === null || $lon === null) {
            return $zip;
        }

        $response = (new Client())->get(
            self::BASE_URL,
            [
                'query' => [
                    'lat' => $lat,
                    'lon' => $lon,
                    'format' => 'json',
                ],
            ]
        );

        if ($response->getStatusCode() === 200) {
            $data = json_decode($response->getBody(), true);

            $zip = $data['address']['postcode'];
        }

        return $zip;
    }
}
