<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\OfferAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Utility\UrlUtility;

class OfferAdapter extends AbstractObjectAdapter implements OfferAdapterInterface
{
    use LanguageAware, MediaCommon;

    /** @var null|string */
    private $detailUriTemplate;

    public function setDetailUriTemplate(?string $detailUriTemplate): void
    {
        $this->detailUriTemplate = $detailUriTemplate;
    }

    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['offer']['serviceID']);
    }

    public function getName(): string
    {
        return strip_tags((string) $this->object['offer']['serviceDescribingName']);
    }

    public function getStartingPrice(): ?float
    {
        $price = $this->extractMinimumPrice();
        $value = $price['value'] ?? null;
        return $value ? ((float) $value) : null;
    }

    public function getStartingPriceCurrency(): ?string
    {
        $price = $this->extractMinimumPrice();
        $currency = $price['currency'] ?? null;
        return $currency ? strip_tags((string) $currency) : null;
    }

    public function getAddress(): ?string
    {
        $address = strip_tags($this->object['geoResult']['address'] ?? '');
        return $address ?: null;
    }

    public function getDurationMinutes(): ?int
    {
        return null;
    }

    private function extractMinimumPrice()
    {
        $price = null;
        foreach ($this->object['availability'] ?? [] as $availability) {
            if (!$availability || !$availability['minimumBasePrice']) {
                continue;
            }

            if (!$price) {
                $price = $availability['minimumBasePrice'];
            } elseif ($availability['minimumBasePrice']['value'] < $price['value']) {
                $price = $availability['minimumBasePrice'];
            }
        }
        return $price;
    }

    public function getDetailUri(): ?string
    {
        if (!$this->detailUriTemplate) {
            return null;
        }

        $niceUrl = $this->object['serviceData']['niceUrl'] ?? null;
        if (!$niceUrl) {
            return null;
        }

        $niceUrl = ltrim($niceUrl, '/');
        $languageSegment = $this->getLanguage() ?? 'de';

        return str_replace(
            [ '{tportalUriSegment}', '{languageSegment}' ],
            [ $niceUrl, $languageSegment ],
            $this->detailUriTemplate
        );
    }
}
