<?php declare(strict_types=1);
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{
    /**
     * @var string
     */
    protected const IMAGE_URL = 'https://img.oastatic.com/imgsrc/:id/.jpg';

    /**
     * @var integer
     */
    protected $sorting;

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE . '_' . $this->object['id'];
    }

    public function getSourceUri(): string
    {
        return str_replace(':id', (string) $this->object['id'], self::IMAGE_URL);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['source'] ?? null;
        return $copyright ? strip_tags((string) $copyright) : null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['title'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }
}
