<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Service\Toubiz\Legacy\TourApiService\EventApiService;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventDate\EventDateAdapter;

class EventDateAdapterTest extends FunctionalTestCase
{

    public function testEndTimeIsMapped(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_end' => '18:00' ]);
        $this->assertEquals('2020-01-01T18:00:00', $adapter->getEndsAt()->format('Y-m-d\TH:i:s'));
    }

    public function testEndsAtSpecificTimeIfEndTimeIsNotEmpty(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_end' => '17:00' ]);
        $this->assertTrue($adapter->getEndsAtSpecificTime());
    }

    public function testAssumesEndDateLastsUntilEndOfDayIfTimeIsEmpty(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_end' => '' ]);
        $this->assertEquals('2020-01-01T23:59:59', $adapter->getEndsAt()->format('Y-m-d\TH:i:s'));
    }


    /** @dataProvider provideEmptyTimeStrings */
    public function testDoesNotEndAtSpecificTimeIfEndTimeIsEmpty($empty): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_end' => $empty ]);
        $this->assertFalse($adapter->getEndsAtSpecificTime());
    }

    public function provideEmptyTimeStrings(): array
    {
        return [
            [ '' ],
            [ '0' ],
            [ ' ' ],
            [ '00' ],
            [ '00:00' ],
            [ '00:00:00' ],
            [ '0:0' ],
            [ null ],
            [ false ]
        ];
    }

    public function testBeginsAtIsMapped(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_begin' => '12:00' ]);
        $this->assertEquals('2020-01-01T12:00:00', $adapter->getBeginsAt()->format('Y-m-d\TH:i:s'));
    }

    public function testBeginsAtSpecificTimeIfHasNonZeroBeginningTime(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_begin' => '12:00' ]);
        $this->assertTrue($adapter->getBeginsAtSpecificTime());
    }

    /** @dataProvider provideEmptyTimeStrings */
    public function testLogicalDateIsMidnightIfStartTimeIsEmpty($empty): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_begin' => $empty ]);
        $this->assertEquals('2020-01-01T00:00:00', $adapter->getBeginsAt()->format('Y-m-d\TH:i:s'));
    }

    public function testDoesNotBeginAtSpecificTimeIfHasZeroBeginningTime(): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_begin' => '00:00' ]);
        $this->assertFalse($adapter->getBeginsAtSpecificTime());
    }

    /** @dataProvider provideEmptyTimeStrings */
    public function testDoesNotBeginAtSpecificTimeIfBeginningTimeIsEmpty($empty): void
    {
        $adapter = new EventDateAdapter([ 'date' => '2020-01-01', 'time_begin' => $empty ]);
        $this->assertFalse($adapter->getBeginsAtSpecificTime());
    }

}
