<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Article;

use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;

interface ArticleTypeCityAdapterInterface
{
    /**
     * Returns an object of lists with related records (articles, categories, etc)
     *
     * @return RelatedListsAdapterInterface|null
     */
    public function getRelatedLists(): ?RelatedListsAdapterInterface;

    /**
     * Cities have a list of zip codes. This is important for filtering by city.
     *
     * @return string[]
     */
    public function getZipCodes(): array;

    /**
     * The id from the toubiz system. Needed for filtering of tportal event lists.
     *
     * @deprecated
     * @TODO Remove
     * @return string
     */
    public function getIdToubiz(): string;

    /**
     * The id from the tomas system. Needed for filtering of tportal lodging lists.
     *
     * @deprecated
     * @TODO Remove
     * @return string
     */
    public function getIdTomas(): string;

    public function getClaim(): string;

    public function getFacts(): string;

    public function getWebcamUrl(): ?string;

    public function getWebcamDescription(): ?string;

    public function getNews(): ?string;
}
