<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

trait StarRatingCommon
{

    public function getStarRatings(): array
    {
        $starAttributes = array_values(
            array_filter(
                $this->object['housedata']['out']['dataClassAttributeValues'] ?? [],
                function (array $attribute) {
                    return ($attribute['twsDataClassAttribute']['name'] ?? null) === 'ClassificationServiceProvider'
                        && ($attribute['twsLookupValues']['externalID'] ?? null) !== null
                        ;
                }
            )
        );

        return array_map(
            function (array $attribute) {
                return new StarRatingAdapter($attribute);
            },
            $starAttributes
        );
    }
}
