<?php declare(strict_types=1);
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use GuzzleHttp\Promise\RejectedPromise;
use GuzzleHttp\Promise\RejectionException;

trait Limitable
{
    /**
     * @var int|null
     */
    protected $limit;

    public function setLimit(int $limit = null): void
    {
        $this->limit = $limit;
    }

    protected function exceedsLimit(int $number): bool
    {
        return !$this->withinLimit($number);
    }

    protected function withinLimit(int $number): bool
    {
        return $this->limit === null || $number <= $this->limit;
    }
}
