<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\CategoryAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;

trait UsesCategoryMap
{
    /**
     * @var CategoryMap
     */
    protected $categoryMap;

    /**
     * Blacklisted IDs from archived categories from Toubiz
     * @var array
     */
    protected $blacklistedCategoryIds = [
        '5758f3d49b725747423f71a9ed42756d',
        '038ddf3c1597190620ab104ac8f1d521',
        '86cbfaa477e28b352918d54db0b55321',
        'cbac2eaa5c2bf7242a12d3e6af55cc8c',
        '7194bb358ffad2965b4ec175f41384c9'
    ];

    public function setCategoryMap(CategoryMap $categoryMap): void
    {
        $this->categoryMap = $categoryMap;
    }

    protected function extractCategories(callable $categoryInstanciator): array
    {
        $categories = [];

        // We omit the main category from 'main_type' because it is always included in the categories from 'type'.
        $categoryData = $this->object['object']['data_map']['type'];
        $categoryIds = explode('#', $categoryData['remote_ids']);

        $categoryIds = array_filter(
            $categoryIds,
            function ($value) {
                return $value !== '';
            }
        );
        $mainCategoryId = $this->object['object']['data_map']['type_main']['remote_id'];

        $addedIds = [];
        foreach ($categoryIds as $categoryId) {
            if (!in_array($categoryId, $this->blacklistedCategoryIds)) {
                $name = $this->categoryMap->getName($categoryId);
                if ($name !== '') {
                    $addedIds[] = $categoryId;
                    $categories[] = $categoryInstanciator([ 'remote_id' => $categoryId, 'name' => $name ]);
                } elseif ($categoryId !== $mainCategoryId) {
                    $this->logger->warning(
                        sprintf(
                            'Category with remote_id %s not found in category map',
                            $categoryId
                        )
                    );
                }
            }
        }

        if (!\in_array($mainCategoryId, $addedIds, true)) {
            $categories[] = $categoryInstanciator(
                [
                    'remote_id' => $mainCategoryId,
                    'name' => $this->object['object']['data_map']['type_main']['content'],
                ]
            );
        }
        return $this->moveMainCategoryToTop($categories, $mainCategoryId);
    }


    /**
     * @param array $categories
     * @param string $mainCategoryId
     * @return CategoryAdapterInterface[]
     */
    public function moveMainCategoryToTop(array $categories, string $mainCategoryId): array
    {
        usort(
            $categories,
            function (CategoryAdapterInterface $categoryA, CategoryAdapterInterface $categoryB) use ($mainCategoryId) {
                return $categoryA->getExternalId() === $mainCategoryId ? -1 : 1;
            }
        );

        return $categories;
    }
}
