<?php
namespace Newland\ToubizApi\Tests\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService\GastronomyAdapter;
use PHPUnit\Framework\TestCase;

class GastronomyAdapterTest extends TestCase
{


    const JSON_DATA = '/../../../../../../Fixtures/GastroData/gastroData.json';

    public function testMediumImport(): void
    {
        $data = json_decode(
            (string) file_get_contents(__DIR__ . self::JSON_DATA),
            true
        );

        $gastroData = array_map(
            function ($gastro) {
                return new GastronomyAdapter($gastro);
            },
            $data
        );
        $this->assertCount(3, $gastroData);
    }

    public function testLatitudeAndLongitudeImport(): void
    {
        $data = json_decode(
            (string) file_get_contents(__DIR__ . self::JSON_DATA),
            true
        );

        $gastroData = array_map(
            function ($gastro) {
                return new GastronomyAdapter($gastro);
            },
            $data
        );

        foreach ($gastroData as $gastro) {
            $this->assertIsFloat($gastro->getLongitude());
            $this->assertIsFloat($gastro->getLatitude());
        }
    }

    /** @dataProvider provideProperties */
    public function testExtractsMultiplePropertiesAsMultipleAttributes(
        string $propertyName,
        int $count,
        $propertyValue
    ): void {
        $adapter = new GastronomyAdapter(
            [
                'remote_id' => 'test',
                'property' => [
                    $propertyName => $propertyValue,
                ],
            ]
        );

        $this->assertCount($count, $adapter->getAttributes());
    }

    public function provideProperties(): array
    {
        return [
            'simple' => [
                'gastro_kitchen',
                2,
                [
                    [ 'text' => 'foo' ],
                    [ 'text' => 'bar' ],
                ],
            ],
            'properties' => [
                'gastro_kitchen',
                2,
                [
                    [
                        'properties' => [
                            [ 'text' => 'foo' ],
                            [ 'text' => 'bar' ],
                        ],
                    ],
                ],
            ],
            'multiple properties' => [
                'gastro_kitchen',
                3,
                [
                    [ 'properties' => [ [ 'text' => 'foo' ] ] ],
                    [ 'properties' => [ [ 'text' => 'bar' ], [ 'text' => 'baz' ] ] ],
                ],
            ],
        ];
    }

    public function testPrependsValueIfAvailable(): void
    {
        $adapter = new GastronomyAdapter(
            [
                'remote_id' => 'test',
                'property' => [
                    'gastro_kitchen' => [
                        [ 'value' => 'foo', 'text' => 'bar' ]
                    ]
                ],
            ]
        );

        $this->assertEquals('bar: foo', $adapter->getAttributes()[0]->getData());
    }
}
