<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Constants\EntityListType;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\EntityListAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;
use Newland\Toubiz\Api\Service\WithUuidPredictionService;
use Newland\Toubiz\Api\Utility\ArrayUtility;

class RelatedListsAdapter implements RelatedListsAdapterInterface
{
    use WithUuidPredictionService;

    /**
     * @var array
     */
    protected $object;
    /**
     * @var EntityListAdapterInterface
     */
    protected $poiHighlights;

    /**
     * @var EntityListAdapterInterface[]
     */
    protected $categoryLists = [];

    public function __construct(array $object)
    {
        $this->object = $object;
    }

    public function getHighlightsList(): ?EntityListAdapterInterface
    {
        return $this->getRelatedHighlightsList();
    }

    public function getEntityLists(): array
    {
        return $this->getRelatedCategoryLists();
    }

    private function getRelatedHighlightsList(): EntityListAdapter
    {
        $ids = ArrayUtility::emptyExplode(
            '#',
            $this->object['object']['data_map']['poi_highlights']['remote_ids'] ?? ''
        );

        $adapter = new EntityListAdapter(
            EntityListType::ARTICLES,
            '',
            $ids
        );
        $adapter->setUuidPredictionService($this->uuidPredictionService);

        return $adapter;
    }

    private function getRelatedCategoryLists(): array
    {
        $lists = [];

        $index = 1;
        while ($this->hasRelatedCategoryListForIndex((string) $index)) {
            $title = $this->object['object']['data_map']['list_' . $index . '_name']['content'] ?? '';
            $ids = ArrayUtility::emptyExplode(
                '#',
                $this->object['object']['data_map']['list_' . $index . '_cats']['remote_ids'] ?? ''
            );

            if (!empty($ids)) {
                $list = new EntityListAdapter(
                    EntityListType::CATEGORIES,
                    $title,
                    $ids
                );
                $list->setUuidPredictionService($this->uuidPredictionService);

                $lists[] = $list;
            }
            $index++;
        }

        return $lists;
    }

    private function hasRelatedCategoryListForIndex(string $index): bool
    {
        return array_key_exists('list_' . $index . '_name', $this->object['object']['data_map'])
            && array_key_exists('list_' . $index . '_cats', $this->object['object']['data_map']);
    }
}
