<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Concern;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Slope constants.
 *
 * Constants for regions, used in interfaces and implementations.
 */
interface SlopeConstants
{
    /**
     * @var int Status for slopes in the dark.
     */
    const STATUS_DARK = 0;

    /**
     * @var int Status for closed slopes.
     */
    const STATUS_CLOSED = 1;

    /**
     * @var int Status for open slopes.
     */
    const STATUS_OPEN = 2;

    /**
     * @var int Status for slopes in preparation.
     */
    const STATUS_IN_PREPARATION = 3;

    /**
     * @var int Status for closed slopes due to stormy weather.
     */
    const STATUS_CLOSED_REASON_STORM = 4;

    /**
     * @var int Status for closed slopes because they don't operate outside the current season.
     */
    const STATUS_END_OF_SEASON = 5;

    /**
     * @var int Status for freshly prepared slopes.
     */
    const STATUS_PREPARED_FRESHLY = 6;

    /**
     * @var int Status for not marked and not controlled slopes.
     */
    const STATUS_NOT_MARKED = 7;

    /**
     * @var int Status for temporarily closed slopes.
     */
    const STATUS_TEMPORARY_CLOSED = 8;

    /**
     * @var array Definition of statuses that say "open".
     */
    const DEFINITION_STATUS_OPEN = [
        self::STATUS_OPEN
    ];

    /**
     * @var int Type for skiing slopes.
     */
    const TYPE_SKI = 0;

    /**
     * @var int Type for sled trails.
     */
    const TYPE_SLED_TRAIL = 1;

    /**
     * @var int Type for hiking trails.
     */
    const TYPE_HIKING_TRAIL = 2;

    /**
     * @var int Type for hiking trails with snow shoes.
     */
    const TYPE_SNOWSHOE_HIKING_TRAIL = 3;

    /**
     * @var int Type for fun units (e.g. funparks).
     */
    const TYPE_FUN = 4;

    /**
     * @var int Type for free-ride slopes.
     */
    const TYPE_FREERIDE = 5;

    /**
     * @var int Type for classic cross-country skiing with fixed tracks.
     */
    const TYPE_CROSS_COUNTRY_SKIING = 6;

    /**
     * @var int Type for skating-style cross-country skiing without fixed tracks.
     */
    const TYPE_CROSS_COUNTRY_SKIING_SKATING = 7;

    /**
     * @var int Easy difficulty.
     */
    const DIFFICULTY_EASY = 0;

    /**
     * @var int Medium difficulty.
     */
    const DIFFICULTY_MEDIUM = 1;

    /**
     * @var int Hard difficulty.
     */
    const DIFFICULTY_HARD = 2;
}
