<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getStreet(): ?string
    {
        return $this->object['housedata']['out']['address']['street'] ?? null;
    }

    public function getZip(): ?string
    {
        return $this->object['housedata']['out']['address']['zipCode'] ?? null;
    }

    public function getCity(): ?string
    {
        return $this->object['housedata']['out']['address']['city'] ?? null;
    }

    public function getCountry(): ?string
    {
        return $this->object['housedata']['out']['address']['country']['name'] ?? null;
    }

    public function getLatitude(): ?float
    {
        return $this->object['housedata']['out']['address']['gmapsLatitude'] ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->object['housedata']['out']['address']['gmapsLongitude'] ?? null;
    }

    public function isLookup(): bool
    {
        return true;
    }

    public function getExternalId(): string
    {
        return 'main_address_' . $this->object['housedata']['out']['ID'];
    }

    public function getTitle(): ?string
    {
        return $this->object['name'] ?? '';
    }

    public function getFirstName(): ?string
    {
        return $this->object['housedata']['out']['address']['personFirstName'] ?? null;
    }

    public function getLastName(): ?string
    {
        return $this->object['housedata']['out']['address']['personLastName'] ?? null;
    }

    public function getPhoneNumber(): ?string
    {
        return '';
    }

    public function getFaxNumber(): ?string
    {
        return '';
    }

    public function getEmailAddress(): ?string
    {
        return '';
    }

    public function getWebsiteAddress(): ?string
    {
        return '';
    }
}
