<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return (string) $this->object['object']['id'];
    }

    public function getTitle(): ?string
    {
        return $this->object['object']['data_map']['address_title']['content'];
    }

    public function getFirstName(): ?string
    {
        return null;
    }

    public function getLastName(): ?string
    {
        return null;
    }

    public function getStreet(): ?string
    {
        $value = $this->object['object']['data_map']['street']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    public function getZip(): ?string
    {
        $value = $this->object['object']['data_map']['zip']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    public function getCity(): ?string
    {
        $value = $this->object['city'] ?? null;
        if ($value) {
            return $value;
        }

        $value = $this->object['object']['data_map']['city']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->object['object']['data_map']['phone']['content'] ?? null;
    }

    public function getFaxNumber(): ?string
    {
        return $this->object['object']['data_map']['fax']['content'] ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->object['object']['data_map']['email']['content'] ?? null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['object']['data_map']['url']['content'] ?? '';

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        $latitude = $this->object['object']['data_map']['geodata']['content']['latitude'] ?? null;

        if ($latitude) {
            return (float) $latitude;
        }

        return null;
    }

    public function getLongitude(): ?float
    {
        $latitude = $this->object['object']['data_map']['geodata']['content']['longitude'] ?? null;

        if ($latitude) {
            return (float) $latitude;
        }

        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
