<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService\DirectMarketerAdapter;
use PHPUnit\Framework\TestCase;

class DirectMarketerAdapterTest extends TestCase
{
    /** @dataProvider providerProductCategoryProperties */
    public function testImportsMultipleProductCategoriesAsMultipleAttributes(
        string $propertyName,
        int $expectedCount,
        $propertyValue
    ): void {
        $adapter = new DirectMarketerAdapter(
            [
                'remote_id' => 'test',
                'property' => [ $propertyName => $propertyValue ],
            ]
        );
        $this->assertCount($expectedCount, $adapter->getAttributes());
    }

    public function providerProductCategoryProperties(): array
    {
        return [
            'simple' => [
                'dv_prod_cat_fleisch',
                2,
                [
                    [ 'text' => 'Rind' ],
                    [ 'text' => 'Schwein' ],
                ],
            ],
            'has properties' => [
                'dv_marketing',
                2,
                [
                    [
                        'properties' => [
                            [ 'text' => 'foo' ],
                            [ 'text' => 'bar' ],
                        ],
                    ],
                ],
            ],
            'has multiple properties' => [
                'dv_marketing',
                3,
                [
                    [ 'properties' => [ [ 'text' => 'foo' ] ] ],
                    [ 'properties' => [ [ 'text' => 'bar' ], [ 'text' => 'baz' ] ] ],
                ],
            ],
        ];
    }
}
