<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['id'];
    }

    public function getSourceUri(): string
    {
        return $this->object['reference'];
    }

    public function getCopyright(): ?string
    {
        return $this->object['copyright'] ?? null;
    }

    public function getTitle(): ?string
    {
        return $this->object['title'] ?? null;
    }
}
