<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

/**
 * Address adapter.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['addressTypeID'];
    }

    public function getTitle(): ?string
    {
        return $this->object['name'] ?? null;
    }

    public function getFirstName(): ?string
    {
        return $this->object['firstname'] ?? null;
    }

    public function getLastName(): ?string
    {
        return $this->object['lastname'] ?? null;
    }

    public function getStreet(): ?string
    {
        return $this->object['street'] ?? null;
    }

    public function getZip(): ?string
    {
        if (empty($this->object['zip'] ?? null)) {
            return null;
        }

        return $this->object['zip'];
    }

    public function getCity(): ?string
    {
        return $this->object['city'] ?? null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        return null;
    }

    public function getFaxNumber(): ?string
    {
        return null;
    }

    public function getEmailAddress(): ?string
    {
        return null;
    }

    public function getWebsiteAddress(): ?string
    {
        return null;
    }

    public function getLatitude(): ?float
    {
        return null;
    }

    public function getLongitude(): ?float
    {
        return null;
    }

    public function isLookup(): bool
    {
        return false;
    }
}
