<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\GpsParser;

/**
 * Parser for the GPX file format
 */
class KmlParser extends Parser
{
    /**
     * This function takes a raw array and extracts each track point to a formatted object
     * The resulting array of objects (points) can be used to calculate multiple things
     * TODO: Handle multiple track segments
     *
     * @param string $file
     * @return array
     */
    public function extractTrack(string $file): array
    {
        $track = [];
        // Convert the file data to an array
        $array = $this->parseXmlAsAssociativeArray($file);

        // Find the placemark tag, which contains track coordinates
        $placemark = [];
        if (isset($array['Document']['Placemark'])) {
            $placemark = $array['Document']['Placemark'];
        }

        foreach ($placemark as $place) {
            // Search for tags that can be used to store a track
            if (isset($place['MultiGeometry'])) {
                $points = explode(' ', (string) $place['MultiGeometry']['LineString']['coordinates']);
                $points = explode("\n", $points[0]);
            } elseif (isset($place['LineString'])) {
                $points = explode(' ', (string) $place['LineString']['coordinates']);
                $points = explode("\n", $points[0]);
            } elseif (isset($place['Point']) && isset($place['Point']['coordinates'])) {
                $points = [ $place['Point']['coordinates'] ];
            }

            // IF we have points, proceed to extract their information
            if (isset($points)) {
                foreach ($points as $point) {
                    $tmp = explode(',', $point);

                    $point = [
                        (float) $tmp[0],
                        (float) $tmp[1],
                    ];
                    $track[] = $point;
                }
            }
            // TODO Else condition: No points could be found in this file
        }

        return $track;
    }
}
