<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Concern;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Article constants.
 *
 * Constants for articles, used in interfaces and implementations.
 */
interface ArticleConstants
{
    const ALL_TYPES = [
        self::TYPE_ATTRACTION,
        self::TYPE_GASTRONOMY,
        self::TYPE_TOUR,
        self::TYPE_LODGING,
        self::TYPE_DIRECT_MARKETER,
        self::TYPE_CONGRESS_LOCATION,
        self::TYPE_CITY,
    ];

    /**
     * @var int Default type, used for basically all POI.
     */
    const TYPE_ATTRACTION = 0;

    const TYPE_GASTRONOMY = 1;

    const TYPE_TOUR = 2;

    const TYPE_LODGING = 3;

    const TYPE_DIRECT_MARKETER = 4;

    const TYPE_CONGRESS_LOCATION = 5;

    const TYPE_CITY = 6;

    /**
     * @var string Format for opening times from the legacy toubiz api.
     */
    const OPENING_TIMES_FORMAT_LEGACY = 'legacy';
}
