<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * File adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class FileAdapter extends AbstractLegacyObjectAdapter implements FileAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return md5($this->object['file_path'] . $this->object['file_path']);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->object['name'];
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return $this->object['file_path'];
    }
}
