<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Concern;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Transportation facility constants.
 *
 * Constants for transportation facilities, used in interfaces and implementations.
 */
interface TransportationFacilityConstants
{
    /**
     * @var int Type for a simple ski lift.
     */
    const TYPE_SKI_LIFT = 0;

    /**
     * @var int Type for chairlift with 4 seats.
     */
    const TYPE_4_SEATER_CHAIRLIFT = 1;

    /**
     * @var int Type for chairlift with 6 seats.
     */
    const TYPE_6_SEATER_CHAIRLIFT = 2;

    /**
     * @var int Type for a gondola.
     */
    const TYPE_GONDOLA = 3;

    /**
     * @var int Type for a reversible aerial tram.
     */
    const TYPE_REVERSIBLE_AERIAL_TRAM = 4;

    /**
     * @var int Type for a cogwheel railway.
     */
    const TYPE_COGWHEEL_RAILWAY = 5;

    /**
     * @var int Status for facilities in the dark.
     */
    const STATUS_DARK = 0;

    /**
     * @var int Status for closed facilities.
     */
    const STATUS_CLOSED = 1;

    /**
     * @var int Status for operating facilities.
     */
    const STATUS_OPEN = 2;

    /**
     * @var int Status for facilities in preparation.
     */
    const STATUS_IN_PREPARATION = 3;

    /**
     * @var int Status for closed facilities due to stormy weather.
     */
    const STATUS_CLOSED_REASON_STORM = 4;

    /**
     * @var int Status for closed facilities because they don't operate outside the current season.
     */
    const STATUS_CLOSED_END_OF_SEASON = 5;

    /**
     * @var int Status for closed facilities because of avalanche hazards.
     */
    const STATUS_CLOSED_REASON_AVALANCHE_HAZARD = 7;

    /**
     * @var int Status for temporary closed facilities.
     */
    const STATUS_TEMPORARY_CLOSED = 8;

    /**
     * @var array Definition of statuses that say "open".
     */
    const DEFINITION_STATUS_OPEN = [
        self::STATUS_OPEN
    ];
}
