<?php
namespace Newland\Toubiz\Api\Utility;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use function \Safe\preg_replace;

class UrlConverter
{
    public static function forceHttps(?string $url = null): ?string
    {
        if ($url === null) {
            return null;
        }

        $result = preg_replace('/^http:\/\//', 'https://', $url);
        if (is_array($result)) {
            $result = implode('', $result);
        }

        return $result;
    }
}
