<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\OfferAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Utility\UrlConverter;

class OfferAdapter extends AbstractObjectAdapter implements OfferAdapterInterface
{
    use LanguageAware;

    /** @var string */
    private $detailUriTemplate;

    public function setDetailUriTemplate(string $template): void
    {
        $this->detailUriTemplate = $template;
    }

    public function getExternalId(): string
    {
        return $this->object['offer']['serviceID'];
    }

    public function getName(): string
    {
        return $this->object['offer']['serviceDescribingName'];
    }

    public function getPreviewImage()
    {
        return UrlConverter::forceHttps($this->object['offer']['previewImageURL'] ?? null);
    }

    public function getStartingPrice()
    {
        $price = $this->extractMinimumPrice();
        return $price ? $price['value'] : null;
    }

    public function getStartingPriceCurrency()
    {
        $price = $this->extractMinimumPrice();
        return $price ? $price['currency'] : null;
    }

    public function getAddress()
    {
        $address = strip_tags($this->object['geoResult']['address'] ?? '');
        return $address !== '' ? $address : null;
    }

    public function getDurationMinutes()
    {
        return null;
    }

    private function extractMinimumPrice()
    {
        $price = null;
        foreach ($this->object['availability'] ?? [] as $availability) {
            if (!$availability || !$availability['minimumBasePrice']) {
                continue;
            }

            if (!$price) {
                $price = $availability['minimumBasePrice'];
            } elseif ($availability['minimumBasePrice']['value'] < $price['value']) {
                $price = $availability['minimumBasePrice'];
            }
        }
        return $price;
    }

    public function getDetailUri(): ?string
    {
        if (!$this->detailUriTemplate) {
            return null;
        }

        $niceUrl = $this->object['serviceData']['niceUrl'] ?? null;
        if (!$niceUrl) {
            return null;
        }

        $niceUrl = ltrim($niceUrl, '/');
        return str_replace('{tportalUriSegment}', $niceUrl, $this->detailUriTemplate);
    }
}
