<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventDate;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Event date adapter.
 */
class EventDateAdapter extends AbstractLegacyObjectAdapter implements EventDateAdapterInterface
{
    /** @var string|null */
    protected $detailUriTemplate;

    public function setDetailUriTemplate(?string $detailUriTemplate): void
    {
        $this->detailUriTemplate = $detailUriTemplate;
    }

    public function getExternalId(): string
    {
        return (string) $this->object['dateTypeID'];
    }

    /**
     * @return \DateTime
     */
    public function getBeginsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date'],
            $this->object['time_begin']
        );
    }

    /**
     * @return \DateTime
     */
    public function getEndsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date'],
            $this->object['time_end']
        );
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->object['additional_title'];
    }
}
