<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return md5($this->object['imageURL']);
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        if (empty($this->object['imageURL'])) {
            return $this->object['imageURLsmall'];
        }

        return $this->object['imageURL'];
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
        return '';
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        $description = null;
        if ($this->object['description']
            && array_key_exists('text', $this->object['description'])
        ) {
            $description = $this->object['description']['text'];
        }

        return $description;
    }
}
