<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Attributes;

interface TourAttributes
{
    /**
     * Name of the data source.
     * Value must be one of the `DATA_SOURCE_*` constants.
     */
    const DATA_SOURCE = 'dataSource';
    const DATA_SOURCE_OUTDOOR_ACTIVE = 'outdooractive';

    /**
     * Id of the article at the external data source.
     */
    const DATA_SOURCE_ID = 'dataSourceId';

    /**
     * Status of a tour: open or closed.
     */
    const ISCLOSED = 'isClosed';

    /**
     * Length of the tour in meters.
     */
    const TOUR_LENGTH = 'tourLength';

    /**
     * Duration of the tour in minutes.
     */
    const TOUR_DURATION = 'tourDuration';

    const TECHNIQUE_RATING = 'techniqueRating';
    const LANDSCAPE_RATING = 'landscapeRating';
    const EXPERIENCE_RATING = 'experienceRating';
    const DIFFICULTY_RATING = 'difficultyRating';
    const CONDITION_RATING = 'conditionRating';

    const STARTING_POINT = 'startingPoint';
    const ENDING_POINT = 'endingPoint';
    const PRIVATE_TRANSIT = 'privateTransit';
    const PUBLIC_TRANSIT = 'publicTransit';

    /**
     * Various tag-like properties.
     * Must receive an array of multiple string values.
     */
    const PROPERTIES = 'properties';

    /**
     * Minimum altitude of the tour in meters.
     */
    const MINIMUM_ALTITUDE = 'minimumAltitude';

    /**
     * Maximum altitude of the tour in meters.
     */
    const MAXIMUM_ALTITUDE = 'maximumAltitude';

    /**
     * Geometry: Array of points in the following format:
     * ```
     * [
     *      [ latitude, longitude ],
     *      [ latitude, longitude ],
     *      ...
     * ]
     * ```
     */
    const GEOMETRY = 'geometry';

    /**
     * String description of the equipment that is necesarry
     * for the tour.
     */
    const NECESARRY_EQUIPMENT = 'equipment';

    /**
     * Elevation differences in the tour (up & down).
     */
    const ASCEND_ELEVATION = 'ascentElevation';
    const DESCENT_ELEVATION = 'descentElevation';

    /**
     * Best season to do this tour in.
     * Must be an array of months as identified by `MonthConstants`.
     */
    const BEST_SEASON = 'bestSeason';

    const DIRECTIONS = 'directions';
    const PARKING = 'parking';
    const ADDITIONAL_INFORMATION = 'additionalInformation';
    const HINT_OF_AUTHOR = 'tipOfAuthor';
    const SAFETY_NOTE = 'safetyNote';
}
