<?php
namespace Newland\ToubizApi\Tests\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService\GastronomyAdapter;
use PHPUnit\Framework\TestCase;

class GastronomyAdapterTest extends TestCase
{
    /**
     * @var GastronomyAdapter
     */
    protected $subject;

    const JSON_DATA = '/../../../../../../Fixtures/GastroData/gastroData.json';

    /**
     * Multiple array types tested,
     * Associative and non associative
     */
    public function testMediumImport(): void
    {

        $data = json_decode(
            (string) file_get_contents(__DIR__ . self::JSON_DATA),
            true
        );

        $gastroData = array_map(
            function ($gastro) {
                return new GastronomyAdapter($gastro);
            },
            $data
        );

        $this->assertTrue(true);

    }
}
