<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Medium adapter interface.
 *
 * Defines the interface for medium adapters
 * representing multimedia contents from Toubiz.
 */
interface MediumAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns an URI pointing to the (external) source.
     *
     * @return string
     */
    public function getSourceUri();

    /**
     * Returns the title of this medium.
     *
     * @return string
     */
    public function getTitle();

    /**
     * Returns the copyright of this medium.
     *
     * @return string
     */
    public function getCopyright();

    /**
     * Returns an integer that defines the sorting
     * of this medium, or null if sorting is irrelevant.
     *
     * @return integer|null
     */
    public function getSorting();
}
