<?php
namespace Newland\Toubiz\Api\Utility;

class ArrayUtility
{
    public static function isAssociative(array $array): bool
    {
        foreach (array_keys($array) as $key) {
            if (!is_int($key)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Get a value from an array by simple key or path:
     *
     * ```
     * $array = [ 'foo' => [ 'bar' => 'baz' ] ];
     * ArrayUtility::arrayGet($array, ['foo', 'bar']); // returns 'baz'
     * ```
     *
     * @param array $array
     * @param string|array $key
     * @return array|mixed|null
     */
    public static function arrayGet(array $array, $key)
    {
        foreach (is_array($key) ? $key : [$key] as $k) {
            if (is_array($array) && array_key_exists($k, $array)) {
                $array = $array[$k];
            } else {
                return null;
            }
        }
        return $array;
    }

    /**
     * @param string $delimiter
     * @param string $input
     * @return string[]
     */
    public static function trimExplode(string $delimiter, string $input): array
    {
        $exploded = explode($delimiter, $input);
        if ($exploded === false) {
            return [];
        }

        return array_map(
            function (string $element) {
                return trim($element);
            },
            $exploded
        );
    }

    public static function isTwoDimensionalArrayOfPrimitives($input): bool
    {
        return \is_array($input)
            && !static::isAssociative($input)
            && static::isArrayOfPrimitives($input[0] ?? null);
    }

    public static function isArrayOfPrimitives($input): bool
    {
        return \is_array($input) && !static::isAssociative($input) && \is_scalar($input[0] ?? null);
    }
}
