<?php
namespace Newland\Toubiz\Api\Service\Meteotest;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter\WeatherAdapter;

/**
 * Service for Meteotest API.
 */
class ApiService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const DEFAULT_BASE_URI = 'https://mdx.meteotest.ch/';

    /**
     * @var string Action name for the API endpoint.
     */
    protected $action;

    /**
     * @var bool
     */
    private $debug = false;

    /**
     * @param string $action
     * @return void
     */
    public function setAction($action)
    {
        $this->action = $action;
    }

    /**
     * Fetches forecast.
     *
     * @return array
     */
    public function fetchForecast(): array
    {
        $locations = [];

        if ($this->debug) {
            $locationDataRaw = $this->getDummyData();
        } else {
            $locationDataRaw = $this->getDataFromApi();
        }

        foreach ($locationDataRaw as $locationName => $weatherDataRaw) {
            $locations[$locationName] = new WeatherAdapter($locationName, $weatherDataRaw);
        }

        return $locations;
    }

    /**
     * Get static dummy data for testing.
     *
     * @return array
     */
    private function getDummyData(): array
    {
        $data = json_decode(
            (string) file_get_contents(__DIR__ . '/../../../Tests/Fixtures/WeatherData/meteotest.json'),
            true
        );

        return $data['payload']['mos'];
    }

    /**
     * @return array
     */
    private function getDataFromApi(): array
    {
        $locations = [];

        $response = $this->httpClient->request('GET', $this->getUri());
        if ($response->getStatusCode() === 200) {
            $data = json_decode($response->getBody(), true);
            $locations = $data['payload']['mos'];
        }

        return $locations;
    }

    private function getUri(): string
    {
        $parameters = [
            ':apiKey' => $this->apiKey,
            ':action' => $this->parameters['action'],
        ];

        $uri = str_replace(
            array_keys($parameters),
            $parameters,
            self::DEFAULT_BASE_URI . 'api_v1?key=:apiKey&service=prod2data&action=:action&format=json'
        );

        return $uri;
    }
}
