<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['ID'];
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        // The response is http but it supports https.
        return str_replace('http://', 'https://', $this->object['url']);
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
        if (array_key_exists('copyrightHolder', $this->object)) {
            return $this->object['copyrightHolder'];
        }
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        if (array_key_exists('comment', $this->object)) {
            return $this->object['comment'];
        }
    }

    /**
     * @return integer|null
     */
    public function getSorting()
    {
    }
}
