<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\BrochureFilterConfigurationAdapterInterface as ConfigurationInterface;

class BrochureFilterConfigurationAdapter extends AbstractObjectAdapter implements ConfigurationInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['mandant'];
    }

    public function getCategories(): array
    {
        return $this->extractAssociative('categories', 'property', 'text');
    }

    public function getTargets(): array
    {
        return $this->extractAssociative('target', 'property', 'text');
    }

    public function getSources(): array
    {
        return $this->extractAssociative('resonanz', 'key', 'text');
    }

    public function getTermsOfService(): string
    {
        return $this->object['agb'][0]['file_path'] ?? '';
    }

    private function extractAssociative(string $key, string $identifierKey, string $valueKey)
    {
        $items = [];
        foreach (($this->object[$key] ?? []) as $item) {
            $identifier = $item[$identifierKey] ?? null;
            if ($identifier) {
                $items[$identifier] = $item[$valueKey];
            }
        }
        return $items;
    }
}
