<?php
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;

class AttributeAdapter extends AbstractObjectAdapter implements AttributeAdapterInterface
{
    public function __construct(string $articleExternalId, string $name, $data = null)
    {
        parent::__construct([
            'articleExternalId' => $articleExternalId,
            'name' => $name,
            'data' => $data,
        ]);
    }

    public function getName(): string
    {
        return $this->object['name'];
    }

    public function getData()
    {
        return $this->object['data'];
    }

    public function getGroupId()
    {
        return $this->getGroupIdFromName();
    }

    public function getExternalId(): string
    {
        return (string) $this->object['articleExternalId'];
    }

    protected function getGroupIdFromName(): string
    {
        return 'default';
    }
}
