<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Lodging adapter.
 *
 * This represents an Article with mapping for the Tportal lodging.
 *
 * @Flow\Scope("singleton")
 */
class LodgingAdapter extends AbstractLegacyObjectAdapter implements ArticleAdapterInterface
{
    /**
     * @return int
     */
    public function getMainType()
    {
        return ArticleConstants::TYPE_LODGING;
    }

    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['out']['ID'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        $name = $this->object['out']['sortName'];
        if (empty($name)) {
            $name = $this->object['out']['address']['personFirstName'];
            $name .= ' ';
            $name .= $this->object['out']['address']['personLastName'];
        }
        if (empty(trim($name))) {
            $name = $this->object['out']['describingName'];
        }
        return $name;
    }

    /**
     * @return string
     */
    public function getAbstract()
    {
        // Currently, there is no abstract.
        return '';
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        $part = $this->object['out']['descriptions'];
        if ($part) {
            if (array_key_exists('description', $part)) {
                return $part['description'];
            } else {
                $descriptionPart = $this->findInArray(
                    $part,
                    'descriptionTypeName',
                    'Beschreibung'
                );

                if ($descriptionPart) {
                    return $descriptionPart['description'];
                }
            }
        }
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['out']['address']['street'];
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->object['out']['address']['zipCode'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->object['out']['address']['city'];
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->object['out']['address']['country']['name'];
    }

    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->object['out']['address']['gmapsLatitude'];
    }

    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->object['out']['address']['gmapsLongitude'];
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        // TODO
        return [];
    }

    /**
     * @return array
     */
    public function getAddresses()
    {
        return [];
    }
    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        // TODO
        return [];
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        return [
            'externalUri' => 'https://tportal.toubiz.de/' . $this->object['clientName'] . '/ukv/house/' . $this->getExternalId()
        ];
    }

    /**
     * @return array
     */
    public function getFiles()
    {
        return [];
    }

    /**
     * @return string|null
     */
    public function getFacebookUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getTwitterUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getInstagramUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getYoutubeUri()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getSourceName()
    {
        return;
    }

    /**
     * @return string|null
     */
    public function getAuthorName()
    {
        return;
    }

    /**
     * @return string
     */
    public function getBookingUri()
    {
        // TODO
        return '';
    }
}
