<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;

/**
 * Event date adapter.
 */
class EventDateAdapter extends AbstractLegacyObjectAdapter implements EventDateAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['dateTypeID'];
    }

    /**
     * @return \DateTime
     */
    public function getBeginsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date'],
            $this->object['time_begin']
        );
    }

    /**
     * @return \DateTime
     */
    public function getEndsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date'],
            $this->object['time_end']
        );
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->object['additional_title'];
    }
}
