<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Address adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        // There is not really an id for this.
        return $this->object['id'];
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->object['data_map']['address_title']['name'];
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
    }

    /**
     * @return string
     */
    public function getLastName()
    {
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['data_map']['street']['name'];
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->object['data_map']['zip']['name'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->object['data_map']['city']['name'];
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->object['data_map']['phone']['content'];
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->object['data_map']['email']['content'];
    }

    /**
     * @return string|null
     */
    public function getWebsiteAddress()
    {
        $url = $this->object['data_map']['url']['content'];

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (substr($url, 0, 4) !== 'http') {
            $url = 'http://' . $url;
        }

        return $url;
    }
}
