<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService\GastronomyAdapter;

/**
 * Service for legacy Toubiz gastronomy API.
 *
 * Concrete implementation to communicate with
 * the first, "old" toubiz API returning gastronomy articles.
 */
class GastronomyApiService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://api.toubiz.de/json/gastro/';

    /**
     * Fetch records.
     *
     * @return array<GastronomyAdapter>
     */
    public function fetchRecords()
    {
        $data = $this->fetchInBadges();
        if (!$data) {
            return false;
        }

        $records = [];
        foreach ($data as $item) {
            $records[] = new GastronomyAdapter($item);
        }
        return $records;
    }

    /**
     * Fetches records in badges.
     *
     * This is due to the API returning an emtpy response when
     * too many records are present.
     *
     * @todo Implement logic in abstract service.
     * @return mixed
     */
    protected function fetchInBadges()
    {
        $data = [];
        $offset = 0;
        $limit = 100;
        while (true) {
            $response = $this->sendRequest($offset, $limit);
            if (!$response) {
                return $data;
            }

            $data = array_merge($data, $response);
            $offset += $limit;
        }
        return $data;
    }

    /**
     * Requests data from the API.
     *
     * @param int $offset
     * @param int $limit
     * @return mixed
     */
    protected function sendRequest($offset, $limit)
    {
        $response = $this->httpClient->request(
            'GET',
            'modified.php',
            [
                'query' => [
                    'key' => $this->apiKey,
                    'modified' => 86400000000,
                    'offset' => $offset,
                    'limit' => $limit
                ]
            ]
        );
        if ($response->getStatusCode() == 200) {
            $data = json_decode($response->getBody(), true);
            if ($data['result']) {
                return $data['result']['item'];
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}
